/*
 * Decompiled with CFR 0.152.
 */
package ai.preferred.venom;

import ai.preferred.venom.Worker;
import ai.preferred.venom.WorkerManager;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadedWorkerManager
implements WorkerManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThreadedWorkerManager.class);
    private final ExecutorService executor;
    private final Worker worker;

    public ThreadedWorkerManager(int numThreads) {
        this(Executors.newFixedThreadPool(numThreads));
    }

    public ThreadedWorkerManager(ExecutorService executor) {
        this.executor = executor;
        this.worker = new InnerWorker(executor);
    }

    @Override
    public final Worker getWorker() {
        return this.worker;
    }

    @Override
    public final void interruptAndClose() {
        LOGGER.debug("Forcefully shutting down the worker manager");
        this.executor.shutdownNow();
        try {
            this.executor.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
            LOGGER.debug("The worker manager has been terminated");
        }
        catch (InterruptedException e) {
            LOGGER.warn("Closing has been interrupted", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public final void close() {
        LOGGER.debug("Shutting down the worker manager");
        this.executor.shutdown();
        try {
            if (this.executor.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS)) {
                LOGGER.debug("The worker manager has been terminated");
            } else {
                this.executor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            LOGGER.warn("Closing has been interrupted, forcefully shutting down", (Throwable)e);
            this.executor.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    private static class InnerWorker
    implements Worker {
        private final ExecutorService executor;

        InnerWorker(ExecutorService executor) {
            this.executor = executor;
        }

        @Override
        @NotNull
        public <T> Future<T> submit(@NotNull Callable<T> task) {
            return this.executor.submit(task);
        }

        @Override
        @NotNull
        public <T> Future<T> submit(@NotNull Runnable task, T result) {
            return this.executor.submit(task, result);
        }

        @Override
        @NotNull
        public Future<?> submit(@NotNull Runnable task) {
            return this.executor.submit(task);
        }
    }
}

