/*
 * Decompiled with CFR 0.152.
 */
package ai.preferred.venom.request;

import ai.preferred.venom.SleepScheduler;
import ai.preferred.venom.request.Request;
import ai.preferred.venom.request.Unwrappable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.http.HttpHost;

public class HttpFetcherRequest
implements Request,
Unwrappable {
    private final Request innerRequest;
    private final Map<String, String> headers;
    private final HttpHost proxy;
    private final Diagnostics diagnostics;

    public HttpFetcherRequest(Request innerRequest) {
        this(innerRequest, new HashMap<String, String>(innerRequest.getHeaders()), innerRequest.getProxy());
    }

    private HttpFetcherRequest(Request innerRequest, Map<String, String> headers, HttpHost proxy) {
        this.innerRequest = innerRequest;
        this.headers = headers;
        this.proxy = proxy;
        this.diagnostics = new Diagnostics();
    }

    public final HttpFetcherRequest prependHeaders(Map<String, String> preHeaders) {
        HashMap<String, String> newHeaders = new HashMap<String, String>(this.headers);
        preHeaders.forEach(newHeaders::putIfAbsent);
        return new HttpFetcherRequest(this.innerRequest, newHeaders, this.proxy);
    }

    @Override
    public final Request.Method getMethod() {
        return this.innerRequest.getMethod();
    }

    @Override
    public final String getBody() {
        return this.innerRequest.getBody();
    }

    @Override
    public final String getUrl() {
        return this.innerRequest.getUrl();
    }

    @Override
    public final Map<String, String> getHeaders() {
        return Collections.unmodifiableMap(this.headers);
    }

    @Override
    public final HttpHost getProxy() {
        return this.proxy;
    }

    public final HttpFetcherRequest setProxy(HttpHost proxy) {
        return new HttpFetcherRequest(this.innerRequest, this.headers, proxy);
    }

    @Override
    public final SleepScheduler getSleepScheduler() {
        return this.innerRequest.getSleepScheduler();
    }

    @Override
    public final Request getInner() {
        return this.innerRequest;
    }

    public final Diagnostics getDiagnostics() {
        return this.diagnostics;
    }

    public static class Diagnostics {
        private Long start;
        private Long acknowledge;
        private Long complete;
        private Integer size;

        private Diagnostics() {
        }

        public void setStart() {
            this.start = System.nanoTime();
        }

        public void setAcknowledge() {
            this.acknowledge = System.nanoTime();
        }

        public void setComplete() {
            this.complete = System.nanoTime();
        }

        public void setSize(int size) {
            this.size = size;
        }

        @Nullable
        public Long getStart() {
            return this.start;
        }

        @Nullable
        public Long getAcknowledge() {
            return this.acknowledge;
        }

        @Nullable
        public Long getComplete() {
            return this.complete;
        }

        @Nullable
        public Integer getSize() {
            return this.size;
        }

        @Nullable
        public Long getLatency() {
            if (this.isAcknowledged()) {
                return this.acknowledge - this.start;
            }
            return null;
        }

        @Nullable
        public Double getSpeed() {
            if (this.isCompleted()) {
                return (double)this.size.intValue() / ((double)(this.complete - this.acknowledge) / 1.0E9);
            }
            return null;
        }

        public boolean isStarted() {
            return this.start != null;
        }

        public boolean isAcknowledged() {
            return this.isStarted() && this.acknowledge != null;
        }

        public boolean isCompleted() {
            return this.isStarted() && this.isAcknowledged() && this.complete != null;
        }
    }
}

