/*
 * Decompiled with CFR 0.152.
 */
package ai.preferred.venom.request;

import ai.preferred.venom.SleepScheduler;
import ai.preferred.venom.request.Request;
import ai.preferred.venom.request.Unwrappable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpHost;

public class HttpFetcherRequest
implements Request,
Unwrappable {
    private final Request innerRequest;
    private final Map<String, String> headers;
    private final HttpHost proxy;

    public HttpFetcherRequest(Request request) {
        this(request, new HashMap<String, String>(request.getHeaders()), request.getProxy());
    }

    private HttpFetcherRequest(Request innerRequest, Map<String, String> headers, HttpHost proxy) {
        this.innerRequest = innerRequest;
        this.headers = headers;
        this.proxy = proxy;
    }

    public HttpFetcherRequest setProxy(HttpHost proxy) {
        return new HttpFetcherRequest(this.innerRequest, this.headers, proxy);
    }

    public HttpFetcherRequest prependHeaders(Map<String, String> preHeaders) {
        HashMap<String, String> newHeaders = new HashMap<String, String>(this.headers);
        preHeaders.forEach(newHeaders::putIfAbsent);
        return new HttpFetcherRequest(this.innerRequest, newHeaders, this.proxy);
    }

    @Override
    public Request.Method getMethod() {
        return this.innerRequest.getMethod();
    }

    @Override
    public String getBody() {
        return this.innerRequest.getBody();
    }

    @Override
    public String getUrl() {
        return this.innerRequest.getUrl();
    }

    @Override
    public Map<String, String> getHeaders() {
        return Collections.unmodifiableMap(this.headers);
    }

    @Override
    public HttpHost getProxy() {
        return this.proxy;
    }

    @Override
    public SleepScheduler getSleepScheduler() {
        return this.innerRequest.getSleepScheduler();
    }

    @Override
    public Request getInner() {
        return this.innerRequest;
    }
}

