/*
 * Decompiled with CFR 0.152.
 */
package ai.preferred.venom.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.helper.StringUtil;

public class UrlUtils {
    private static String resolveHrefs(String html, String baseUrl, Pattern pattern) {
        StringBuilder sb = new StringBuilder();
        Matcher matcher = pattern.matcher(html);
        int lastEnd = 0;
        boolean modified = false;
        while (matcher.find()) {
            modified = true;
            sb.append(StringUtils.substring((String)html, (int)lastEnd, (int)matcher.start()));
            sb.append(matcher.group(1));
            sb.append('\"').append(StringUtil.resolve((String)baseUrl, (String)matcher.group(2))).append('\"');
            lastEnd = matcher.end();
        }
        if (!modified) {
            return html;
        }
        sb.append(StringUtils.substring((String)html, (int)lastEnd));
        return sb.toString();
    }

    public static String resolveUrls(String html, String baseUrl) {
        html = UrlUtils.resolveHrefs(html, baseUrl, Pattern.compile("(<a[^<>]*href=)[\"']([^\"'<>]*)[\"']", 2));
        html = UrlUtils.resolveHrefs(html, baseUrl, Pattern.compile("(<a[^<>]*href=)([^\"'<>\\s]+)", 2));
        return html;
    }

    private UrlUtils() {
        throw new AssertionError();
    }
}

