/*
 * Decompiled with CFR 0.152.
 */
package ai.preferred.venom;

import ai.preferred.venom.Interruptible;
import ai.preferred.venom.Worker;
import ai.preferred.venom.WorkerManager;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadedWorkerManager
implements WorkerManager,
Interruptible {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThreadedWorkerManager.class);
    private final ExecutorService executor;
    private final Worker worker;

    public ThreadedWorkerManager(int numThreads) {
        this(Executors.newFixedThreadPool(numThreads));
    }

    public ThreadedWorkerManager(ExecutorService executor) {
        this.executor = executor;
        this.worker = new InnerWorker(executor);
    }

    @Override
    public final Worker getWorker() {
        return this.worker;
    }

    @Override
    public final void interruptAndClose() throws InterruptedException {
        this.executor.shutdownNow();
        this.close();
    }

    @Override
    public final void close() throws InterruptedException {
        LOGGER.debug("Initialising processor shutdown, waiting for threads to join...");
        this.executor.shutdown();
        this.executor.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
        LOGGER.debug("Processor thread pool joined.");
        LOGGER.debug("Processor shutdown completed.");
    }

    private static class InnerWorker
    implements Worker {
        private final ExecutorService executor;

        InnerWorker(ExecutorService executor) {
            this.executor = executor;
        }

        @Override
        @NotNull
        public <T> Future<T> submit(@NotNull Callable<T> task) {
            return this.executor.submit(task);
        }

        @Override
        @NotNull
        public <T> Future<T> submit(@NotNull Runnable task, T result) {
            return this.executor.submit(task, result);
        }

        @Override
        @NotNull
        public Future<?> submit(@NotNull Runnable task) {
            return this.executor.submit(task);
        }
    }
}

