/*
 * Decompiled with CFR 0.152.
 */
package ai.preferred.venom;

import java.util.Random;
import javax.validation.constraints.NotNull;

public class SleepScheduler {
    private final Random random;
    private final long min;
    private final long max;

    public SleepScheduler(long sleepTime) {
        this(sleepTime, sleepTime, null);
    }

    public SleepScheduler(long min, long max) {
        this(min, max, new Random(System.currentTimeMillis() * 13L));
    }

    private SleepScheduler(long min, long max, @NotNull Random random) {
        if (min < 0L) {
            throw new IllegalArgumentException("Sleep time cannot be less than 0.");
        }
        this.min = min;
        if (min > max) {
            throw new IllegalArgumentException("Sleep time in \"min\" cannot be greater less than \"max\".");
        }
        this.max = max;
        this.random = random;
    }

    public final long getSleepTime() {
        if (this.min == this.max) {
            return this.min;
        }
        return (long)this.random.nextInt((int)(this.max - this.min)) + this.min;
    }
}

