/*
 * Decompiled with CFR 0.152.
 */
package ai.preferred.venom.fetcher;

import ai.preferred.venom.ProxyProvider;
import ai.preferred.venom.ValidatorRouter;
import ai.preferred.venom.fetcher.AsyncResponseConsumer;
import ai.preferred.venom.fetcher.Callback;
import ai.preferred.venom.fetcher.Fetcher;
import ai.preferred.venom.request.HttpFetcherRequest;
import ai.preferred.venom.request.Request;
import ai.preferred.venom.response.Response;
import ai.preferred.venom.storage.FileManager;
import ai.preferred.venom.uagent.DefaultUserAgent;
import ai.preferred.venom.uagent.UserAgent;
import ai.preferred.venom.validator.EmptyContentValidator;
import ai.preferred.venom.validator.PipelineValidator;
import ai.preferred.venom.validator.StatusOkValidator;
import ai.preferred.venom.validator.Validator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.protocol.RequestAcceptEncoding;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.concurrent.BasicFuture;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.nio.client.methods.HttpAsyncMethods;
import org.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncFetcher
implements Fetcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncFetcher.class);
    private static final FutureCallback<Response> EMPTY_CALLBACK = new FutureCallback<Response>(){

        public void completed(Response result) {
        }

        public void failed(Exception ex) {
        }

        public void cancelled() {
        }
    };
    @NotNull
    private final List<Callback> callbacks;
    @NotNull
    private final Map<String, String> headers;
    @NotNull
    private final CloseableHttpAsyncClient httpClient;
    @Nullable
    private final ProxyProvider proxyProvider;
    @NotNull
    private final Set<Integer> stopCodes;
    @NotNull
    private final UserAgent userAgent;
    @NotNull
    private final Validator validator;
    @Nullable
    private final ValidatorRouter router;
    private final int connectionRequestTimeout;
    private final boolean compressed;

    private AsyncFetcher(Builder builder) {
        ImmutableList.Builder callbackListBuilder = new ImmutableList.Builder();
        if (builder.fileManager != null) {
            callbackListBuilder.add((Object)builder.fileManager.getCallback());
        }
        callbackListBuilder.addAll((Iterable)builder.callbacks);
        this.callbacks = callbackListBuilder.build();
        this.headers = builder.headers;
        this.proxyProvider = builder.proxyProvider;
        this.stopCodes = builder.stopCodes;
        this.userAgent = builder.userAgent;
        this.validator = builder.validator;
        this.router = builder.router;
        this.connectionRequestTimeout = builder.connectionRequestTimeout;
        this.compressed = builder.compressed;
        IOReactorConfig reactorConfig = IOReactorConfig.custom().setIoThreadCount(builder.numIoThreads).setSoKeepAlive(true).setTcpNoDelay(true).setConnectTimeout(builder.connectTimeout).setSoTimeout(builder.socketTimeout).build();
        HttpAsyncClientBuilder clientBuilder = HttpAsyncClientBuilder.create().setDefaultIOReactorConfig(reactorConfig).setThreadFactory(builder.threadFactory);
        if (builder.compressed) {
            clientBuilder.addInterceptorLast((HttpRequestInterceptor)new RequestAcceptEncoding());
        }
        this.httpClient = clientBuilder.build();
    }

    public static AsyncFetcher buildDefault() {
        return AsyncFetcher.builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private HttpFetcherRequest normalizeRequest(Request request) {
        if (request instanceof HttpFetcherRequest) {
            return (HttpFetcherRequest)request;
        }
        return new HttpFetcherRequest(request);
    }

    private HttpFetcherRequest prepareFetcherRequest(Request request) {
        HttpFetcherRequest httpFetcherRequest = this.normalizeRequest(request);
        if (!this.headers.isEmpty()) {
            httpFetcherRequest = httpFetcherRequest.prependHeaders(this.headers);
        }
        if (this.proxyProvider != null && httpFetcherRequest.getInner().getProxy() == null) {
            httpFetcherRequest = httpFetcherRequest.setProxy(this.proxyProvider.get(request));
        }
        return httpFetcherRequest;
    }

    private RequestBuilder createRequestBuilder(Request request) {
        switch (request.getMethod()) {
            case GET: {
                return RequestBuilder.get();
            }
            case POST: {
                return RequestBuilder.post();
            }
            case HEAD: {
                return RequestBuilder.head();
            }
            case PUT: {
                return RequestBuilder.put();
            }
            case DELETE: {
                return RequestBuilder.delete();
            }
            case OPTIONS: {
                return RequestBuilder.options();
            }
        }
        throw new RuntimeException("Request method is not defined");
    }

    private HttpUriRequest prepareHttpRequest(HttpFetcherRequest request) {
        RequestConfig config = RequestConfig.custom().setConnectionRequestTimeout(this.connectionRequestTimeout).setProxy(request.getProxy()).build();
        RequestBuilder requestBuilder = this.createRequestBuilder(request).addHeader("User-Agent", this.userAgent.get()).setUri(request.getUrl()).setConfig(config);
        request.getHeaders().forEach((arg_0, arg_1) -> ((RequestBuilder)requestBuilder).setHeader(arg_0, arg_1));
        if (request.getBody() != null) {
            requestBuilder.setEntity((HttpEntity)new ByteArrayEntity(request.getBody().getBytes()));
        }
        return requestBuilder.build();
    }

    private Validator prepareValidator(Validator routedValidator) {
        if (routedValidator == null) {
            return this.validator;
        }
        return new PipelineValidator(this.validator, routedValidator);
    }

    private HttpHost determineTarget(HttpUriRequest request) throws ClientProtocolException {
        HttpHost target = null;
        URI requestURI = request.getURI();
        if (requestURI.isAbsolute() && (target = URIUtils.extractHost((URI)requestURI)) == null) {
            throw new ClientProtocolException("URI does not specify a valid host name: " + requestURI);
        }
        return target;
    }

    @Override
    public Future<Response> fetch(Request request) {
        return this.fetch(request, EMPTY_CALLBACK);
    }

    @Override
    public Future<Response> fetch(final Request request, final FutureCallback<Response> callback) {
        HttpHost target;
        final HttpFetcherRequest httpFetcherRequest = this.prepareFetcherRequest(request);
        FutureCallback<Response> futureCallback = new FutureCallback<Response>(){

            public void completed(Response response) {
                LOGGER.debug("Executing completion callback on {}.", (Object)request.getUrl());
                AsyncFetcher.this.callbacks.forEach(callback -> callback.completed(httpFetcherRequest, response));
                callback.completed((Object)response);
            }

            public void failed(Exception ex) {
                LOGGER.debug("Executing failed callback on {}.", (Object)request.getUrl(), (Object)ex);
                AsyncFetcher.this.callbacks.forEach(callback -> callback.failed(httpFetcherRequest, ex));
                callback.failed(ex);
            }

            public void cancelled() {
                LOGGER.debug("Executing cancelled callback on {}.", (Object)request.getUrl());
                AsyncFetcher.this.callbacks.forEach(callback -> callback.cancelled(httpFetcherRequest));
                callback.cancelled();
            }
        };
        HttpUriRequest httpReq = this.prepareHttpRequest(httpFetcherRequest);
        try {
            target = this.determineTarget(httpReq);
        }
        catch (ClientProtocolException ex) {
            BasicFuture future = new BasicFuture((FutureCallback)futureCallback);
            future.failed((Exception)((Object)ex));
            return future;
        }
        LOGGER.debug("Fetching URL: {}", (Object)request.getUrl());
        Validator routedValidator = this.router != null ? this.router.getValidator(request) : null;
        return this.httpClient.execute(HttpAsyncMethods.create((HttpHost)target, (HttpRequest)httpReq), (HttpAsyncResponseConsumer)new AsyncResponseConsumer(this.prepareValidator(routedValidator), this.stopCodes, this.compressed, httpFetcherRequest), (HttpContext)HttpClientContext.create(), (FutureCallback)futureCallback);
    }

    @Override
    public void start() {
        this.httpClient.start();
    }

    @Override
    public void close() throws Exception {
        LOGGER.debug("Initialising fetcher shutdown...");
        this.httpClient.close();
        LOGGER.debug("Fetcher shutdown completed.");
    }

    public static class Builder {
        private final List<Callback> callbacks = new ArrayList<Callback>();
        private FileManager fileManager = null;
        private Map<String, String> headers = Collections.emptyMap();
        private int numIoThreads = Runtime.getRuntime().availableProcessors();
        private ProxyProvider proxyProvider = null;
        private Set<Integer> stopCodes = Collections.emptySet();
        private ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("I/O Dispatcher %d").build();
        private UserAgent userAgent = new DefaultUserAgent();
        private Validator validator = new PipelineValidator(StatusOkValidator.INSTANCE, EmptyContentValidator.INSTANCE);
        private ValidatorRouter router = request -> Validator.ALWAYS_VALID;
        private int connectionRequestTimeout = -1;
        private int connectTimeout = -1;
        private int socketTimeout = -1;
        private boolean compressed = true;

        private Builder() {
        }

        public Builder register(@NotNull Callback callback) {
            this.callbacks.add(callback);
            return this;
        }

        public Builder fileManager(@NotNull FileManager fileManager) {
            this.fileManager = fileManager;
            return this;
        }

        public Builder headers(@NotNull Map<String, String> headers) {
            this.headers = headers;
            return this;
        }

        public Builder numIoThreads(int numIoThreads) {
            this.numIoThreads = numIoThreads;
            return this;
        }

        public Builder proxyProvider(@NotNull ProxyProvider proxyProvider) {
            this.proxyProvider = proxyProvider;
            return this;
        }

        public Builder stopCodes(int ... codes) {
            ImmutableSet.Builder builder = new ImmutableSet.Builder();
            for (int code : codes) {
                builder.add((Object)code);
            }
            this.stopCodes = builder.build();
            return this;
        }

        public Builder threadFactory(@NotNull ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
            return this;
        }

        public Builder userAgent(@NotNull UserAgent userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        public Builder validator(@NotNull Validator validator) {
            this.validator = validator;
            return this;
        }

        public Builder validator(Validator ... validators) {
            this.validator = new PipelineValidator(validators);
            return this;
        }

        public Builder router(@NotNull ValidatorRouter router) {
            this.router = router;
            return this;
        }

        public Builder connectionRequestTimeout(int connectionRequestTimeout) {
            this.connectionRequestTimeout = connectionRequestTimeout;
            return this;
        }

        public Builder connectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder socketTimeout(int socketTimeout) {
            this.socketTimeout = socketTimeout;
            return this;
        }

        public Builder compressed(boolean compressed) {
            this.compressed = compressed;
            return this;
        }

        public AsyncFetcher build() {
            return new AsyncFetcher(this);
        }
    }
}

