/*
 * Decompiled with CFR 0.152.
 */
package ai.preferred.venom;

import ai.preferred.venom.FatalHandlerException;
import ai.preferred.venom.Handler;
import ai.preferred.venom.HandlerRouter;
import ai.preferred.venom.Interruptible;
import ai.preferred.venom.Session;
import ai.preferred.venom.SleepScheduler;
import ai.preferred.venom.ThreadedWorkerManager;
import ai.preferred.venom.WorkerManager;
import ai.preferred.venom.fetcher.AsyncFetcher;
import ai.preferred.venom.fetcher.Callback;
import ai.preferred.venom.fetcher.Fetcher;
import ai.preferred.venom.fetcher.StopCodeException;
import ai.preferred.venom.fetcher.ValidationException;
import ai.preferred.venom.job.Job;
import ai.preferred.venom.job.PriorityQueueScheduler;
import ai.preferred.venom.job.QueueScheduler;
import ai.preferred.venom.job.Scheduler;
import ai.preferred.venom.request.CrawlerRequest;
import ai.preferred.venom.request.Request;
import ai.preferred.venom.response.Response;
import ai.preferred.venom.response.VResponse;
import ai.preferred.venom.validator.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Crawler
implements Interruptible {
    private static final Logger LOGGER = LoggerFactory.getLogger(Crawler.class);
    @NotNull
    private final Thread crawlerThread;
    @NotNull
    private final AtomicBoolean exitWhenDone;
    @NotNull
    private final Fetcher fetcher;
    private final int maxTries;
    private final double propRetainProxy;
    @Nullable
    private final HandlerRouter router;
    @NotNull
    private final QueueScheduler queueScheduler;
    @NotNull
    private final Semaphore connections;
    @NotNull
    private final Session session;
    @Nullable
    private final SleepScheduler sleepScheduler;
    @NotNull
    private final ForkJoinPool threadPool;
    @NotNull
    private final WorkerManager workerManager;
    @NotNull
    private final AtomicInteger jobsPending;
    private final List<FatalHandlerException> fatalHandlerExceptions;

    private Crawler(Builder builder) {
        this.crawlerThread = new Thread(this::run, builder.name);
        this.exitWhenDone = new AtomicBoolean(false);
        this.fetcher = builder.fetcher;
        this.maxTries = builder.maxTries;
        this.propRetainProxy = builder.propRetainProxy;
        this.router = builder.router;
        this.queueScheduler = builder.queueScheduler;
        this.connections = new Semaphore(builder.maxConnections);
        this.session = builder.session;
        this.sleepScheduler = builder.sleepScheduler;
        this.threadPool = new ForkJoinPool(builder.parallelism, pool -> {
            ForkJoinWorkerThread worker = ForkJoinPool.defaultForkJoinWorkerThreadFactory.newThread(pool);
            worker.setName(builder.name + " " + worker.getPoolIndex());
            return worker;
        }, null, true);
        this.workerManager = builder.workerManager == null ? new ThreadedWorkerManager(this.threadPool) : builder.workerManager;
        this.jobsPending = new AtomicInteger();
        this.fatalHandlerExceptions = Collections.synchronizedList(new ArrayList());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Crawler buildDefault() {
        return Crawler.builder().build();
    }

    private void sleep(Job job, long lastRequestTime) throws InterruptedException {
        long sleepTime = job.getRequest().getSleepScheduler() == null ? (this.sleepScheduler != null ? this.sleepScheduler.getSleepTime() : 0L) : job.getRequest().getSleepScheduler().getSleepTime();
        long timeElapsed = System.nanoTime() - lastRequestTime;
        long timeElapsedMillis = TimeUnit.NANOSECONDS.toMillis(timeElapsed);
        if (sleepTime > timeElapsedMillis) {
            Thread.sleep(sleepTime - timeElapsedMillis);
        }
    }

    private CrawlerRequest normalizeRequest(Request request) {
        if (request instanceof CrawlerRequest) {
            return (CrawlerRequest)request;
        }
        return new CrawlerRequest(request);
    }

    private CrawlerRequest prepareRequest(Request request, int tryCount) {
        CrawlerRequest crawlerRequest = this.normalizeRequest(request);
        if (request.getProxy() != null && (double)tryCount / (double)this.maxTries > this.propRetainProxy) {
            crawlerRequest.removeProxy();
        }
        return crawlerRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handle(Job job, Response response) {
        try {
            if (job.getHandler() != null) {
                job.getHandler().handle(job.getRequest(), new VResponse(response), this.getScheduler(), this.session, this.workerManager.getWorker());
            } else if (this.router != null) {
                Handler routedHandler = this.router.getHandler(job.getRequest());
                if (routedHandler != null) {
                    routedHandler.handle(job.getRequest(), new VResponse(response), this.getScheduler(), this.session, this.workerManager.getWorker());
                }
            } else {
                LOGGER.error("No handler to handle request {}.", (Object)job.getRequest().getUrl());
            }
        }
        catch (FatalHandlerException e) {
            LOGGER.error("Fatal exception occurred in handler, when parsing response ({}), interrupting execution.", (Object)job.getRequest().getUrl(), (Object)e);
            this.fatalHandlerExceptions.add(e);
        }
        catch (Exception e) {
            LOGGER.error("An exception occurred in handler when parsing response: {}", (Object)job.getRequest().getUrl(), (Object)e);
        }
        finally {
            this.jobsPending.decrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void except(Job job, Throwable ex) {
        if (ex instanceof ValidationException && ((ValidationException)ex).getStatus() == Validator.Status.STOP || ex instanceof StopCodeException || ex instanceof CancellationException) {
            this.jobsPending.decrementAndGet();
        } else {
            AtomicInteger atomicInteger = this.jobsPending;
            synchronized (atomicInteger) {
                this.jobsPending.decrementAndGet();
                if (job.getTryCount() < this.maxTries) {
                    job.prepareRetry();
                    this.queueScheduler.add(job);
                    LOGGER.debug("Job {} - {} re-queued.", (Object)Integer.toHexString(job.hashCode()), (Object)job.getRequest().getUrl());
                } else {
                    LOGGER.error("Max retries reached for request: {}", (Object)job.getRequest().getUrl());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run() {
        this.fetcher.start();
        long lastRequestTime = 0L;
        while (!Thread.currentThread().isInterrupted() && !this.threadPool.isShutdown() && this.fatalHandlerExceptions.isEmpty()) {
            try {
                final Job job = (Job)this.queueScheduler.poll(100L, TimeUnit.MILLISECONDS);
                if (job == null) {
                    if (this.jobsPending.get() > 0) continue;
                    AtomicInteger atomicInteger = this.jobsPending;
                    synchronized (atomicInteger) {
                        LOGGER.debug("({}) Checking for exit conditions.", (Object)this.crawlerThread.getName());
                        if (this.queueScheduler.peek() == null && this.jobsPending.get() <= 0 && this.exitWhenDone.get()) {
                            break;
                        }
                        continue;
                    }
                }
                this.sleep(job, lastRequestTime);
                lastRequestTime = System.nanoTime();
                this.connections.acquire();
                this.jobsPending.incrementAndGet();
                this.threadPool.execute(() -> {
                    LOGGER.debug("Preparing job {} - {} (try {}/{}).", new Object[]{Integer.toHexString(job.hashCode()), job.getRequest().getUrl(), job.getTryCount(), this.maxTries});
                    CrawlerRequest crawlerRequest = this.prepareRequest(job.getRequest(), job.getTryCount());
                    if (Thread.currentThread().isInterrupted()) {
                        this.connections.release();
                        this.jobsPending.decrementAndGet();
                        LOGGER.debug("The thread pool is interrupted");
                        return;
                    }
                    final CompletableFuture completableResponseFuture = new CompletableFuture();
                    ((CompletableFuture)((CompletableFuture)completableResponseFuture.whenComplete((response, throwable) -> this.connections.release())).thenAcceptAsync(response -> this.handle(job, (Response)response), (Executor)this.threadPool)).whenComplete((blank, throwable) -> {
                        if (throwable != null) {
                            Throwable cause = throwable.getCause();
                            this.except(job, cause);
                        }
                    });
                    Callback callback = new Callback(){

                        @Override
                        public void completed(@NotNull Request request, @NotNull Response response) {
                            LOGGER.debug("Completed received for job {} - {}.", (Object)Integer.toHexString(job.hashCode()), (Object)job.getRequest().getUrl());
                            completableResponseFuture.complete(response);
                        }

                        @Override
                        public void failed(@NotNull Request request, @NotNull Exception ex) {
                            LOGGER.debug("Failed received for job {} - {}.", (Object)Integer.toHexString(job.hashCode()), (Object)job.getRequest().getUrl());
                            completableResponseFuture.completeExceptionally(ex);
                        }

                        @Override
                        public void cancelled(@NotNull Request request) {
                            LOGGER.debug("Cancelled received for job {} - {}.", (Object)Integer.toHexString(job.hashCode()), (Object)job.getRequest().getUrl());
                            completableResponseFuture.cancel(true);
                        }
                    };
                    this.fetcher.fetch(crawlerRequest, callback);
                });
            }
            catch (InterruptedException e) {
                LOGGER.debug("({}) producer thread interrupted.", (Object)this.crawlerThread.getName(), (Object)e);
                break;
            }
        }
        if (!this.fatalHandlerExceptions.isEmpty()) {
            LOGGER.debug("Handler exception found... Interrupting.");
            try {
                this.interrupt();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        LOGGER.debug("({}) will stop producing requests.", (Object)this.crawlerThread.getName());
    }

    public Scheduler getScheduler() {
        return this.queueScheduler.getScheduler();
    }

    public synchronized Crawler start() {
        this.crawlerThread.start();
        LOGGER.info("{} thread started.", (Object)this.crawlerThread.getName());
        return this;
    }

    public synchronized Crawler startAndClose() throws Exception {
        this.start();
        this.close();
        return this;
    }

    @Override
    public void interruptAndClose() throws Exception {
        this.interrupt();
        try {
            this.crawlerThread.join();
            this.threadPool.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException e) {
            LOGGER.warn("The joining has been interrupted!", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    private void interrupt() throws Exception {
        this.exitWhenDone.set(true);
        this.crawlerThread.interrupt();
        this.threadPool.shutdownNow();
        Exception cachedException = null;
        for (Interruptible interruptible : new Interruptible[]{this.workerManager, this.fetcher}) {
            try {
                interruptible.interruptAndClose();
            }
            catch (Exception e) {
                if (cachedException != null) {
                    cachedException.addSuppressed(e);
                    continue;
                }
                cachedException = e;
            }
        }
        if (cachedException != null) {
            throw cachedException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        if (this.exitWhenDone.compareAndSet(false, true)) {
            LOGGER.debug("Initialising \"{}\" shutdown, waiting for threads to join...", (Object)this.crawlerThread.getName());
            try {
                this.crawlerThread.join();
                LOGGER.debug("{} producer thread joined.", (Object)this.crawlerThread.getName());
            }
            catch (InterruptedException e) {
                LOGGER.warn("The producer thread joining has been interrupted", (Throwable)e);
                this.threadPool.shutdownNow();
                Thread.currentThread().interrupt();
            }
            this.threadPool.shutdown();
            try {
                this.threadPool.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
            }
            catch (InterruptedException e) {
                LOGGER.warn("The thread pool joining has been interrupted", (Throwable)e);
                Thread.currentThread().interrupt();
            }
            Exception cachedException = null;
            for (AutoCloseable closeable : new AutoCloseable[]{this.workerManager, this.fetcher}) {
                try {
                    closeable.close();
                }
                catch (Exception e) {
                    if (cachedException != null) {
                        cachedException.addSuppressed(e);
                        continue;
                    }
                    cachedException = e;
                }
            }
            if (!this.fatalHandlerExceptions.isEmpty()) {
                FatalHandlerException mainHandlerException;
                List<FatalHandlerException> list = this.fatalHandlerExceptions;
                synchronized (list) {
                    Iterator<FatalHandlerException> iterator = this.fatalHandlerExceptions.iterator();
                    mainHandlerException = iterator.next();
                    while (iterator.hasNext()) {
                        mainHandlerException.addSuppressed(iterator.next());
                    }
                    if (cachedException != null) {
                        mainHandlerException.addSuppressed(cachedException);
                    }
                }
                throw mainHandlerException;
            }
            if (cachedException != null) {
                throw cachedException;
            }
        }
    }

    public static final class Builder {
        private Fetcher fetcher = AsyncFetcher.buildDefault();
        private int maxConnections = 32;
        private int maxTries = 50;
        private String name = "Crawler";
        private int parallelism = Runtime.getRuntime().availableProcessors();
        private WorkerManager workerManager = null;
        private double propRetainProxy = 0.05;
        private HandlerRouter router = null;
        private QueueScheduler queueScheduler = new PriorityQueueScheduler();
        private SleepScheduler sleepScheduler = new SleepScheduler(250L, 2000L);
        private Session session = Session.EMPTY_SESSION;

        private Builder() {
        }

        public Builder setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalStateException("Attribute 'name' cannot be null.");
            }
            this.name = name;
            return this;
        }

        public Builder setFetcher(@NotNull Fetcher fetcher) {
            if (fetcher == null) {
                throw new IllegalStateException("Attribute 'fetcher' cannot be null.");
            }
            this.fetcher = fetcher;
            return this;
        }

        public Builder setParallelism(int parallelism) {
            if (parallelism <= 0) {
                throw new IllegalStateException("Attribute 'parallelism' must be more or equal to 1.");
            }
            this.parallelism = parallelism;
            return this;
        }

        public Builder setWorkerManager(@NotNull WorkerManager workerManager) {
            if (workerManager == null) {
                throw new IllegalStateException("Attribute 'workerManager' cannot be null.");
            }
            this.workerManager = workerManager;
            return this;
        }

        public Builder setScheduler(@NotNull QueueScheduler queueScheduler) {
            if (queueScheduler == null) {
                throw new IllegalStateException("Attribute 'queueScheduler' cannot be null.");
            }
            this.queueScheduler = queueScheduler;
            return this;
        }

        public Builder setHandlerRouter(HandlerRouter router) {
            this.router = router;
            return this;
        }

        public Builder setMaxConnections(int maxConnections) {
            if (maxConnections <= 0) {
                throw new IllegalStateException("Attribute 'maxConnections' must be more or equal to 1.");
            }
            this.maxConnections = maxConnections;
            return this;
        }

        public Builder setMaxTries(int maxTries) {
            if (maxTries <= 0) {
                throw new IllegalStateException("Attribute 'maxTries' must be more or equal to 1.");
            }
            this.maxTries = maxTries;
            return this;
        }

        public Builder setPropRetainProxy(double propRetainProxy) {
            if (propRetainProxy > 1.0 || propRetainProxy < 0.0) {
                throw new IllegalStateException("Attribute 'propRetainProxy' not within range, must be (0,1].");
            }
            this.propRetainProxy = propRetainProxy;
            return this;
        }

        public Builder setSleepScheduler(SleepScheduler sleepScheduler) {
            this.sleepScheduler = sleepScheduler;
            return this;
        }

        public Builder setSession(Session session) {
            if (session == null) {
                this.session = Session.EMPTY_SESSION;
            }
            this.session = session;
            return this;
        }

        public Crawler build() {
            return new Crawler(this);
        }
    }
}

