/*
 * Decompiled with CFR 0.152.
 */
package ai.preferred.venom.fetcher;

import ai.preferred.venom.fetcher.Callback;
import ai.preferred.venom.fetcher.Fetcher;
import ai.preferred.venom.fetcher.ValidationException;
import ai.preferred.venom.request.Request;
import ai.preferred.venom.request.StorageFetcherRequest;
import ai.preferred.venom.request.Unwrappable;
import ai.preferred.venom.response.Response;
import ai.preferred.venom.response.StorageResponse;
import ai.preferred.venom.storage.FileManager;
import ai.preferred.venom.storage.Record;
import ai.preferred.venom.storage.StorageException;
import ai.preferred.venom.utils.UrlUtil;
import ai.preferred.venom.validator.EmptyContentValidator;
import ai.preferred.venom.validator.PipelineValidator;
import ai.preferred.venom.validator.StatusOkValidator;
import ai.preferred.venom.validator.Validator;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Future;
import javax.validation.constraints.NotNull;
import org.apache.http.concurrent.BasicFuture;
import org.apache.http.concurrent.FutureCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StorageFetcher
implements Fetcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(StorageFetcher.class);
    private final FileManager fileManager;
    private final Validator validator;
    private final Map<String, String> headers;

    private StorageFetcher(Builder builder) {
        this.fileManager = builder.fileManager;
        this.validator = builder.validator;
        this.headers = builder.headers;
    }

    public static Builder builder(FileManager fileManager) {
        return new Builder(fileManager);
    }

    private StorageFetcherRequest normalize(Request request) {
        if (request instanceof StorageFetcherRequest) {
            return (StorageFetcherRequest)request;
        }
        return new StorageFetcherRequest(request);
    }

    @Override
    public void start() {
    }

    @Override
    public Future<Response> fetch(Request request) {
        return this.fetch(request, Callback.EMPTY_CALLBACK);
    }

    @Override
    public Future<Response> fetch(final Request request, final Callback callback) {
        LOGGER.debug("Getting record for: {}", (Object)request.getUrl());
        StorageFetcherRequest storageFetcherRequest = this.normalize(request).prependHeaders(this.headers);
        BasicFuture future = new BasicFuture((FutureCallback)new FutureCallback<Response>(){

            public void completed(Response result) {
                callback.completed(request, result);
            }

            public void failed(Exception ex) {
                callback.failed(request, ex);
            }

            public void cancelled() {
                callback.cancelled(request);
            }
        });
        try {
            String tryBaseUrl;
            Record record = this.fileManager.get(storageFetcherRequest);
            if (record == null) {
                future.cancel();
                LOGGER.info("No content found from storage for: {}", (Object)request.getUrl());
                return future;
            }
            LOGGER.debug("Record found with id: {}", record.getId());
            try {
                tryBaseUrl = UrlUtil.getBaseUrl(request);
            }
            catch (URISyntaxException e) {
                LOGGER.warn("Could not parse base URL: " + request.getUrl());
                tryBaseUrl = request.getUrl();
            }
            String baseUrl = tryBaseUrl;
            StorageResponse response = new StorageResponse(record, baseUrl);
            Validator.Status status = this.validator.isValid(Unwrappable.unwrapRequest(request), response);
            if (status != Validator.Status.VALID) {
                future.failed((Exception)new ValidationException(status, (Response)response, "Invalid response."));
                return future;
            }
            future.completed((Object)response);
            return future;
        }
        catch (StorageException e) {
            LOGGER.warn("Error retrieving content for : {}", (Object)request.getUrl(), (Object)e);
            future.failed((Exception)e);
            return future;
        }
    }

    @Override
    public void close() throws Exception {
        if (this.fileManager != null) {
            this.fileManager.close();
        }
    }

    public static final class Builder {
        private final FileManager fileManager;
        private Map<String, String> headers;
        private Validator validator;

        private Builder(FileManager fileManager) {
            this.fileManager = fileManager;
            this.headers = Collections.emptyMap();
            this.validator = new PipelineValidator(StatusOkValidator.INSTANCE, EmptyContentValidator.INSTANCE);
        }

        public Builder setHeaders(@NotNull Map<String, String> headers) {
            this.headers = headers;
            return this;
        }

        public Builder setValidator(@NotNull Validator validator) {
            this.validator = validator;
            return this;
        }

        public Builder setValidator(Validator ... validators) {
            this.validator = new PipelineValidator(validators);
            return this;
        }

        public StorageFetcher build() {
            return new StorageFetcher(this);
        }
    }
}

