/*
 * Decompiled with CFR 0.152.
 */
package ai.preferred.venom.job;

import ai.preferred.venom.Handler;
import ai.preferred.venom.job.JobAttribute;
import ai.preferred.venom.request.Request;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Job {
    private static final Logger LOGGER = LoggerFactory.getLogger(Job.class);
    private final Request request;
    private final Handler handler;
    private final Map<Class<? extends JobAttribute>, JobAttribute> jobAttributeMap = new HashMap<Class<? extends JobAttribute>, JobAttribute>();
    private int tryCount = 1;

    public Job(@NotNull Request request, Handler handler, JobAttribute ... jobAttributes) {
        this.request = request;
        this.handler = handler;
        for (JobAttribute jobAttribute : jobAttributes) {
            this.jobAttributeMap.put(jobAttribute.getClass(), jobAttribute);
        }
    }

    public Job(@NotNull Request request, Handler handler) {
        this(request, handler, new JobAttribute[0]);
    }

    public Job(@NotNull Request request) {
        this(request, null);
    }

    @NotNull
    public final Request getRequest() {
        return this.request;
    }

    @Nullable
    public final Handler getHandler() {
        return this.handler;
    }

    public final int getTryCount() {
        return this.tryCount;
    }

    public final void prepareRetry() {
        LOGGER.debug("Preparing job {} - {} for next state.", (Object)Integer.toHexString(this.hashCode()), (Object)this.request.getUrl());
        this.jobAttributeMap.forEach((k, jobAttribute) -> jobAttribute.prepareRetry());
        ++this.tryCount;
    }

    public final Job setJobAttribute(JobAttribute jobAttribute) {
        this.jobAttributeMap.put(jobAttribute.getClass(), jobAttribute);
        return this;
    }

    public final <T extends JobAttribute> T getJobAttribute(Class<T> clazz) {
        return (T)this.jobAttributeMap.get(clazz);
    }
}

