/*
 * Decompiled with CFR 0.152.
 */
package ai.preferred.venom.job;

import ai.preferred.venom.Handler;
import ai.preferred.venom.job.Job;
import ai.preferred.venom.job.JobAttribute;
import ai.preferred.venom.job.Priority;
import ai.preferred.venom.job.PriorityJobAttribute;
import ai.preferred.venom.job.QueueScheduler;
import ai.preferred.venom.job.Scheduler;
import ai.preferred.venom.request.Request;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobScheduler
implements Scheduler {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobScheduler.class);
    private final QueueScheduler queueScheduler;

    public JobScheduler(QueueScheduler queueScheduler) {
        this.queueScheduler = queueScheduler;
    }

    @Override
    public final void add(@NotNull Request request, Handler handler, JobAttribute ... jobAttributes) {
        Job job = new Job(request, handler, jobAttributes);
        this.queueScheduler.add(job);
        LOGGER.debug("Job {} - {} added to queue.", (Object)job.toString(), (Object)request.getUrl());
    }

    @Override
    public final void add(@NotNull Request request, JobAttribute ... jobAttributes) {
        this.add(request, (Handler)null, jobAttributes);
    }

    @Override
    public final void add(Request request, @NotNull Handler handler) {
        this.add(request, handler, new JobAttribute[0]);
    }

    @Override
    public final void add(@NotNull Request request) {
        this.add(request, (Handler)null, new JobAttribute[0]);
    }

    @Override
    public final void add(@NotNull Request r, Handler h, Priority p, Priority pf) {
        this.add(r, h, new PriorityJobAttribute(p, pf));
    }

    @Override
    public final void add(@NotNull Request r, Handler h, Priority p) {
        this.add(r, h, p, Priority.FLOOR);
    }

    @Override
    public final void add(@NotNull Request r, Priority p, Priority pf) {
        this.add(r, null, p, pf);
    }

    @Override
    public final void add(@NotNull Request r, Priority p) {
        this.add(r, (Handler)null, p);
    }
}

