/*
 * Decompiled with CFR 0.152.
 */
package ai.preferred.venom.storage;

import ai.preferred.venom.fetcher.Callback;
import ai.preferred.venom.request.Request;
import ai.preferred.venom.response.Response;
import ai.preferred.venom.storage.FileManager;
import ai.preferred.venom.storage.FileManagerCallback;
import ai.preferred.venom.storage.Record;
import ai.preferred.venom.storage.StorageException;
import ai.preferred.venom.storage.StorageUtil;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.apache.tika.mime.MimeTypeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DummyFileManager
implements FileManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DummyFileManager.class);
    private final File storagePath;
    private final Callback callback;

    public DummyFileManager(String storageDir) {
        this(new File(storageDir));
    }

    public DummyFileManager(File storagePath) {
        this.storagePath = storagePath;
        this.callback = new FileManagerCallback(this);
    }

    private String write(InputStream in, File parentDir, String filename) throws IOException {
        if (!parentDir.exists() && !parentDir.mkdirs()) {
            throw new IOException("Cannot create the dir: " + parentDir);
        }
        if (parentDir.exists() && !parentDir.isDirectory()) {
            throw new IOException("The path is not a dir: " + parentDir);
        }
        File htmlFile = new File(parentDir, filename);
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(htmlFile));){
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
        return htmlFile.getAbsolutePath();
    }

    @Override
    public final Callback getCallback() {
        return this.callback;
    }

    @Override
    public final String put(Request request, Response response) throws StorageException {
        try {
            String tryFileExtension;
            ByteArrayInputStream content = new ByteArrayInputStream(response.getContent());
            String md5 = DigestUtils.md5Hex((InputStream)content);
            ((InputStream)content).reset();
            String subDirName = md5.substring(0, 2);
            try {
                tryFileExtension = StorageUtil.getFileExtension(response);
            }
            catch (MimeTypeException e) {
                LOGGER.warn("Cannot find mime type defaulting to no extension");
                tryFileExtension = "";
            }
            String fileExtension = tryFileExtension;
            LOGGER.info("Response from request {} has been saved to {}", (Object)request.getUrl(), (Object)(md5 + fileExtension));
            return this.write(content, new File(this.storagePath, subDirName), md5 + fileExtension);
        }
        catch (IOException e) {
            throw new StorageException("Error in put.", e);
        }
    }

    public final Record get(Object i) {
        throw new UnsupportedOperationException("File not found");
    }

    @Override
    public final Record get(Request request) {
        throw new UnsupportedOperationException("File not found");
    }

    @Override
    public final void close() {
    }
}

