/*
 * Decompiled with CFR 0.152.
 */
package ai.preferred.venom.fetcher;

import ai.preferred.venom.ProxyProvider;
import ai.preferred.venom.ValidatorRouter;
import ai.preferred.venom.fetcher.AsyncResponseConsumer;
import ai.preferred.venom.fetcher.Callback;
import ai.preferred.venom.fetcher.Fetcher;
import ai.preferred.venom.request.HttpFetcherRequest;
import ai.preferred.venom.request.Request;
import ai.preferred.venom.response.Response;
import ai.preferred.venom.storage.FileManager;
import ai.preferred.venom.uagent.DefaultUserAgent;
import ai.preferred.venom.uagent.UserAgent;
import ai.preferred.venom.validator.EmptyContentValidator;
import ai.preferred.venom.validator.PipelineValidator;
import ai.preferred.venom.validator.StatusOkValidator;
import ai.preferred.venom.validator.Validator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import javax.annotation.Nullable;
import javax.net.ssl.SSLContext;
import javax.validation.constraints.NotNull;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.protocol.RequestAcceptEncoding;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.concurrent.BasicFuture;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.nio.client.methods.HttpAsyncMethods;
import org.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AsyncFetcher
implements Fetcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncFetcher.class);
    @NotNull
    private final List<Callback> callbacks;
    @NotNull
    private final Map<String, String> headers;
    @NotNull
    private final CloseableHttpAsyncClient httpClient;
    @Nullable
    private final ProxyProvider proxyProvider;
    @NotNull
    private final Set<Integer> stopCodes;
    @NotNull
    private final UserAgent userAgent;
    @NotNull
    private final Validator validator;
    @Nullable
    private final ValidatorRouter router;
    private final int connectionRequestTimeout;
    private final boolean compressed;

    private static Future<Response> failRequest(FutureCallback<Response> callback, Exception ex) {
        BasicFuture f = new BasicFuture(callback);
        f.failed(ex);
        return f;
    }

    private static Future<Response> cancelRequest(FutureCallback<Response> callback) {
        BasicFuture f = new BasicFuture(callback);
        f.cancel(true);
        return f;
    }

    private AsyncFetcher(Builder builder) {
        ImmutableList.Builder callbackListBuilder = new ImmutableList.Builder();
        if (builder.fileManager != null) {
            callbackListBuilder.add((Object)builder.fileManager.getCallback());
        }
        callbackListBuilder.addAll((Iterable)builder.callbacks);
        this.callbacks = callbackListBuilder.build();
        this.headers = builder.headers;
        this.proxyProvider = builder.proxyProvider;
        this.stopCodes = builder.stopCodes;
        this.userAgent = builder.userAgent;
        this.validator = builder.validator;
        this.router = builder.router;
        this.connectionRequestTimeout = builder.connectionRequestTimeout;
        this.compressed = builder.compressed;
        IOReactorConfig reactorConfig = IOReactorConfig.custom().setIoThreadCount(builder.numIoThreads).setSoKeepAlive(true).setConnectTimeout(builder.connectTimeout).setSoTimeout(builder.socketTimeout).build();
        HttpAsyncClientBuilder clientBuilder = HttpAsyncClientBuilder.create().setDefaultIOReactorConfig(reactorConfig).setThreadFactory(builder.threadFactory).setMaxConnPerRoute(builder.maxRouteConnections).setMaxConnTotal(builder.maxConnections).setSSLContext(builder.sslContext).setRedirectStrategy(builder.redirectStrategy);
        if (builder.maxConnections < builder.maxRouteConnections) {
            clientBuilder.setMaxConnTotal(builder.maxRouteConnections);
            LOGGER.info("Maximum total connections will be set to {}, to match maximum route connection.", (Object)builder.maxRouteConnections);
        }
        if (builder.disableCookies) {
            clientBuilder.disableCookieManagement();
        }
        if (builder.compressed) {
            clientBuilder.addInterceptorLast((HttpRequestInterceptor)new RequestAcceptEncoding());
        }
        this.httpClient = clientBuilder.build();
    }

    public static AsyncFetcher buildDefault() {
        return AsyncFetcher.builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private HttpFetcherRequest normalizeRequest(Request request) {
        if (request instanceof HttpFetcherRequest) {
            return (HttpFetcherRequest)request;
        }
        return new HttpFetcherRequest(request);
    }

    private HttpFetcherRequest prepareFetcherRequest(Request request) {
        HttpFetcherRequest httpFetcherRequest = this.normalizeRequest(request);
        if (!this.headers.isEmpty()) {
            httpFetcherRequest = httpFetcherRequest.prependHeaders(this.headers);
        }
        if (this.proxyProvider != null && httpFetcherRequest.getInner().getProxy() == null) {
            httpFetcherRequest = httpFetcherRequest.setProxy(this.proxyProvider.get(request));
        }
        return httpFetcherRequest;
    }

    private RequestBuilder createRequestBuilder(Request request) {
        switch (request.getMethod()) {
            case GET: {
                return RequestBuilder.get();
            }
            case POST: {
                return RequestBuilder.post();
            }
            case HEAD: {
                return RequestBuilder.head();
            }
            case PUT: {
                return RequestBuilder.put();
            }
            case DELETE: {
                return RequestBuilder.delete();
            }
            case OPTIONS: {
                return RequestBuilder.options();
            }
        }
        throw new RuntimeException("Request method is not defined");
    }

    private HttpUriRequest prepareHttpRequest(HttpFetcherRequest request) {
        RequestConfig config = RequestConfig.custom().setConnectionRequestTimeout(this.connectionRequestTimeout).setProxy(request.getProxy()).build();
        RequestBuilder requestBuilder = this.createRequestBuilder(request).addHeader("User-Agent", this.userAgent.get()).setUri(request.getUrl()).setConfig(config);
        request.getHeaders().forEach((arg_0, arg_1) -> ((RequestBuilder)requestBuilder).setHeader(arg_0, arg_1));
        if (request.getBody() != null) {
            requestBuilder.setEntity((HttpEntity)new ByteArrayEntity(request.getBody().getBytes()));
        }
        return requestBuilder.build();
    }

    private Validator prepareValidator(Validator routedValidator) {
        if (routedValidator == null) {
            return this.validator;
        }
        return new PipelineValidator(this.validator, routedValidator);
    }

    private HttpHost determineTarget(HttpUriRequest request) throws ClientProtocolException {
        HttpHost target = null;
        URI requestURI = request.getURI();
        if (requestURI.isAbsolute() && (target = URIUtils.extractHost((URI)requestURI)) == null) {
            throw new ClientProtocolException("URI does not specify a valid host name: " + requestURI);
        }
        return target;
    }

    @Override
    public Future<Response> fetch(Request request) {
        return this.fetch(request, Callback.EMPTY_CALLBACK);
    }

    @Override
    public Future<Response> fetch(final Request request, final Callback callback) {
        HttpHost target;
        final HttpFetcherRequest httpFetcherRequest = this.prepareFetcherRequest(request);
        FutureCallback<Response> futureCallback = new FutureCallback<Response>(){

            public void completed(Response response) {
                LOGGER.debug("Executing completion callback on {}.", (Object)request.getUrl());
                AsyncFetcher.this.callbacks.forEach(callback -> callback.completed(httpFetcherRequest, response));
                callback.completed(httpFetcherRequest, response);
            }

            public void failed(Exception ex) {
                LOGGER.debug("Executing failed callback on {}.", (Object)request.getUrl(), (Object)ex);
                AsyncFetcher.this.callbacks.forEach(callback -> callback.failed(httpFetcherRequest, ex));
                callback.failed(httpFetcherRequest, ex);
            }

            public void cancelled() {
                LOGGER.debug("Executing cancelled callback on {}.", (Object)request.getUrl());
                AsyncFetcher.this.callbacks.forEach(callback -> callback.cancelled(httpFetcherRequest));
                callback.cancelled(httpFetcherRequest);
            }
        };
        if (Thread.currentThread().isInterrupted()) {
            return AsyncFetcher.cancelRequest(futureCallback);
        }
        HttpUriRequest httpReq = this.prepareHttpRequest(httpFetcherRequest);
        try {
            target = this.determineTarget(httpReq);
        }
        catch (ClientProtocolException ex) {
            return AsyncFetcher.failRequest(futureCallback, (Exception)((Object)ex));
        }
        LOGGER.debug("Fetching URL: {}", (Object)request.getUrl());
        Validator routedValidator = this.router != null ? this.router.getValidator(request) : null;
        if (!this.httpClient.isRunning() || Thread.currentThread().isInterrupted()) {
            return AsyncFetcher.cancelRequest(futureCallback);
        }
        return this.httpClient.execute(HttpAsyncMethods.create((HttpHost)target, (HttpRequest)httpReq), (HttpAsyncResponseConsumer)new AsyncResponseConsumer(this.prepareValidator(routedValidator), this.stopCodes, this.compressed, httpFetcherRequest), (HttpContext)HttpClientContext.create(), (FutureCallback)futureCallback);
    }

    @Override
    public void start() {
        this.httpClient.start();
    }

    @Override
    public void close() throws IOException {
        LOGGER.debug("Shutting down the fetcher...");
        this.httpClient.close();
        LOGGER.debug("The fetcher shutdown completed.");
    }

    public static final class Builder {
        private final List<Callback> callbacks = new ArrayList<Callback>();
        private boolean disableCookies = false;
        private FileManager fileManager = null;
        private Map<String, String> headers = Collections.emptyMap();
        private int numIoThreads = Runtime.getRuntime().availableProcessors();
        private int maxConnections = 16;
        private int maxRouteConnections = 8;
        private ProxyProvider proxyProvider = null;
        private SSLContext sslContext;
        private Set<Integer> stopCodes = Collections.emptySet();
        private ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("I/O Dispatcher %d").build();
        private UserAgent userAgent = new DefaultUserAgent();
        private Validator validator = new PipelineValidator(StatusOkValidator.INSTANCE, EmptyContentValidator.INSTANCE);
        private RedirectStrategy redirectStrategy;
        private ValidatorRouter router;
        private int connectionRequestTimeout = -1;
        private int connectTimeout = -1;
        private int socketTimeout = -1;
        private boolean compressed = true;

        private Builder() {
        }

        public Builder register(@NotNull Callback callback) {
            if (callback == null) {
                throw new IllegalStateException("Attribute 'callback' cannot be null.");
            }
            this.callbacks.add(callback);
            return this;
        }

        public Builder disableCookies() {
            this.disableCookies = true;
            return this;
        }

        public Builder setFileManager(FileManager fileManager) {
            this.fileManager = fileManager;
            return this;
        }

        public Builder setHeaders(@NotNull Map<String, String> headers) {
            if (headers == null) {
                throw new IllegalStateException("Attribute 'headers' cannot be null.");
            }
            this.headers = headers;
            return this;
        }

        public Builder setNumIoThreads(int numIoThreads) {
            if (numIoThreads <= 0) {
                throw new IllegalStateException("Attribute 'numIoThreads' must be more or equal to 1.");
            }
            this.numIoThreads = numIoThreads;
            return this;
        }

        public Builder setMaxConnections(int maxConnections) {
            if (maxConnections <= 0) {
                throw new IllegalStateException("Attribute 'maxConnections' must be more or equal to 1.");
            }
            this.maxConnections = maxConnections;
            return this;
        }

        public Builder setMaxRouteConnections(int maxRouteConnections) {
            if (maxRouteConnections <= 0) {
                throw new IllegalStateException("Attribute 'maxRouteConnections' must be more or equal to 1.");
            }
            this.maxRouteConnections = maxRouteConnections;
            return this;
        }

        public Builder setProxyProvider(ProxyProvider proxyProvider) {
            this.proxyProvider = proxyProvider;
            return this;
        }

        public Builder setSslContext(SSLContext sslContext) {
            this.sslContext = sslContext;
            return this;
        }

        public Builder setStopCodes(int ... codes) {
            if (codes == null) {
                throw new IllegalStateException("Attribute 'codes' cannot be null.");
            }
            ImmutableSet.Builder builder = new ImmutableSet.Builder();
            for (int code : codes) {
                builder.add((Object)code);
            }
            this.stopCodes = builder.build();
            return this;
        }

        public Builder setThreadFactory(@NotNull ThreadFactory threadFactory) {
            if (threadFactory == null) {
                throw new IllegalStateException("Attribute 'threadFactory' cannot be null.");
            }
            this.threadFactory = threadFactory;
            return this;
        }

        public Builder setUserAgent(@NotNull UserAgent userAgent) {
            if (userAgent == null) {
                throw new IllegalStateException("Attribute 'userAgent' cannot be null.");
            }
            this.userAgent = userAgent;
            return this;
        }

        public Builder setValidator(@NotNull Validator validator) {
            this.validator = validator;
            return this;
        }

        public Builder setValidator(Validator ... validators) {
            this.validator = new PipelineValidator(validators);
            return this;
        }

        public Builder setRedirectStrategy(RedirectStrategy redirectStrategy) {
            this.redirectStrategy = redirectStrategy;
            return this;
        }

        public Builder setValidatorRouter(ValidatorRouter router) {
            this.router = router;
            return this;
        }

        public Builder setConnectionRequestTimeout(int connectionRequestTimeout) {
            if (connectionRequestTimeout == -1 ^ connectionRequestTimeout < 0) {
                throw new IllegalStateException("Attribute 'connectTimeout' must be -1, or more or equal to 0.");
            }
            this.connectionRequestTimeout = connectionRequestTimeout;
            return this;
        }

        public Builder setConnectTimeout(int connectTimeout) {
            if (connectTimeout == -1 ^ connectTimeout < 0) {
                throw new IllegalStateException("Attribute 'connectTimeout' must be -1, or more or equal to 0.");
            }
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder setSocketTimeout(int socketTimeout) {
            if (socketTimeout == -1 ^ socketTimeout < 0) {
                throw new IllegalStateException("Attribute 'socketTimeout' must be -1, or more or equal to 0.");
            }
            this.socketTimeout = socketTimeout;
            return this;
        }

        public Builder disableCompression() {
            this.compressed = false;
            return this;
        }

        public AsyncFetcher build() {
            return new AsyncFetcher(this);
        }
    }
}

