/*
 * Decompiled with CFR 0.152.
 */
package ai.preferred.venom.socks;

import com.google.common.annotations.Beta;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.protocol.HttpContext;

@Beta
public class SocksHttpRoutePlanner
implements HttpRoutePlanner {
    private final HttpRoutePlanner rp;

    public SocksHttpRoutePlanner(HttpRoutePlanner rp) {
        this.rp = rp;
    }

    public HttpRoute determineRoute(HttpHost host, HttpRequest request, HttpContext context) throws HttpException {
        HttpRoute route = this.rp.determineRoute(host, request, context);
        boolean secure = "https".equalsIgnoreCase(route.getTargetHost().getSchemeName());
        if (secure && route.getProxyHost() != null && "socks".equalsIgnoreCase(route.getProxyHost().getSchemeName())) {
            return new HttpRoute(route.getTargetHost(), route.getLocalAddress(), route.getProxyHost(), false);
        }
        return route;
    }
}

