/*
 * Decompiled with CFR 0.152.
 */
package ai.preferred.venom.storage;

import ai.preferred.venom.fetcher.Callback;
import ai.preferred.venom.request.Request;
import ai.preferred.venom.response.Response;
import ai.preferred.venom.storage.FileManager;
import ai.preferred.venom.storage.FileManagerCallback;
import ai.preferred.venom.storage.Record;
import ai.preferred.venom.storage.StorageException;
import ai.preferred.venom.storage.StorageRecord;
import ai.preferred.venom.storage.StorageUtil;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.zaxxer.hikari.HikariDataSource;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.sql.DataSource;
import javax.validation.constraints.NotNull;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.ParseException;
import org.apache.http.entity.ContentType;
import org.apache.http.message.BasicHeader;
import org.apache.tika.mime.MimeTypeException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MysqlFileManager
implements FileManager<Integer> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MysqlFileManager.class);
    private static final ContentType DEFAULT_CONTENT_TYPE = ContentType.APPLICATION_OCTET_STREAM;
    private final DataSource dataSource;
    private final String table;
    private final File storagePath;
    private final Callback callback;

    public MysqlFileManager(String url, String table, String username, String password, String storageDir) {
        this(url, table, username, password, new File(storageDir));
    }

    public MysqlFileManager(String url, String table, String username, String password, File storagePath) {
        this.dataSource = this.setupDataSource(url, username, password);
        this.ensureTable(table);
        this.table = table;
        this.storagePath = storagePath;
        this.callback = new CompletedThreadedCallback(this);
    }

    private DataSource setupDataSource(String url, String username, String password) {
        HikariDataSource dataSource = new HikariDataSource();
        dataSource.setJdbcUrl(url);
        dataSource.setUsername(username);
        dataSource.setPassword(password);
        dataSource.setAutoCommit(false);
        return dataSource;
    }

    private void ensureTable(String table) {
        try (Connection conn = this.dataSource.getConnection();
             Statement statement = conn.createStatement();){
            String sql = "CREATE TABLE IF NOT EXISTS `" + table + "` (`id` int(11) NOT NULL AUTO_INCREMENT,\n`url` varchar(1024) NOT NULL,\n`method` ENUM('GET', 'POST', 'HEAD', 'PUT', 'DELETE', 'OPTIONS') NOT NULL,\n`request_headers` JSON DEFAULT NULL,\n`request_body` JSON DEFAULT NULL,\n`status_code` int(3) NOT NULL DEFAULT 200,\n`response_headers` JSON DEFAULT NULL,\n`mime_type` varchar(255) NOT NULL,\n`encoding` varchar(255) NULL DEFAULT NULL,\n`md5` varchar(32) NOT NULL,\n`location` varchar(3) NOT NULL,\n`date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,\nPRIMARY KEY (`id`),\nINDEX `url_idx` (`url` ASC)\n) CHARACTER SET latin1 COLLATE latin1_swedish_ci;";
            statement.execute(sql);
            conn.commit();
        }
        catch (SQLException e) {
            LOGGER.error("Unable to execute ensure table query", (Throwable)e);
        }
    }

    private void createFile(InputStream in, File recordDir, String recordName) throws IOException {
        if (!recordDir.exists() && !recordDir.mkdirs()) {
            throw new IOException("Cannot create the record dir: " + recordDir);
        }
        if (recordDir.exists() && !recordDir.isDirectory()) {
            throw new IOException("The record path is not a dir: " + recordDir);
        }
        File recordFile = new File(recordDir, recordName);
        try (BufferedOutputStream out = new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(recordFile)));){
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
    }

    private Map<String, String> parseRequestHeaders(JSONObject json) {
        HashMap<String, String> map = new HashMap<String, String>();
        Iterator i = json.keys();
        while (i.hasNext()) {
            String key = (String)i.next();
            map.put(key, json.getString(key));
        }
        return map;
    }

    private Header[] parseResponseHeaders(JSONObject json) {
        ArrayList<BasicHeader> headers = new ArrayList<BasicHeader>();
        Iterator i = json.keys();
        while (i.hasNext()) {
            String key = (String)i.next();
            headers.add(new BasicHeader(key, json.getString(key)));
        }
        Header[] headersArray = new Header[headers.size()];
        return headers.toArray(headersArray);
    }

    private Map<String, String> prepareRequestBody(Request request) {
        HashMap<String, String> requestBody = new HashMap<String, String>();
        if (request.getBody() != null) {
            for (String pair : request.getBody().split("&")) {
                String[] nvp = pair.split("=");
                String value = nvp.length > 1 ? nvp[1] : "";
                requestBody.put(nvp[0], value);
            }
        }
        return requestBody;
    }

    private ContentType getContentType(String mimeType, String encoding) {
        Charset charset = encoding != null ? Charset.forName(encoding) : null;
        try {
            return ContentType.create((String)mimeType, (Charset)charset);
        }
        catch (ParseException e) {
            LOGGER.warn("Could not parse content type", (Throwable)e);
        }
        catch (UnsupportedCharsetException e) {
            LOGGER.warn("Charset is not available in this instance of the Java virtual machine", (Throwable)e);
        }
        return DEFAULT_CONTENT_TYPE;
    }

    private StorageRecord<Integer> createRecord(ResultSet rs) throws SQLException, StorageException {
        byte[] responseContent;
        String tryFileExtension;
        Map<String, String> requestHeaders = this.parseRequestHeaders(new JSONObject(rs.getString("request_headers")));
        Header[] responseHeaders = this.parseResponseHeaders(new JSONObject(rs.getString("response_headers")));
        String location = rs.getString("location");
        try {
            tryFileExtension = StorageUtil.getFileExtension(rs.getString("mime_type"));
        }
        catch (MimeTypeException e) {
            LOGGER.warn("Cannot find mime type defaulting to no extension");
            tryFileExtension = "";
        }
        String fileExtension = tryFileExtension;
        File file = new File(new File(this.storagePath, location), rs.getString("id") + fileExtension + ".gz");
        ContentType contentType = this.getContentType(rs.getString("mime_type"), rs.getString("encoding"));
        try {
            responseContent = IOUtils.toByteArray((InputStream)new BufferedInputStream(new GZIPInputStream(new FileInputStream(file))));
        }
        catch (FileNotFoundException e) {
            throw new StorageException("Record found but file not found for " + rs.getString("url") + ".", e);
        }
        catch (IOException e) {
            throw new StorageException("Error reading file for " + rs.getString("url") + ".", e);
        }
        LOGGER.debug("Record found for request: {}", (Object)rs.getString("url"));
        return StorageRecord.builder().setId(rs.getInt("id")).setUrl(rs.getString("url")).setRequestMethod(Request.Method.valueOf(rs.getString("method"))).setRequestHeaders(requestHeaders).setResponseHeaders(responseHeaders).setContentType(contentType).setMD5(rs.getString("md5")).setDateCreated(rs.getLong("date_created")).setResponseContent(responseContent).build();
    }

    @Override
    public final Callback getCallback() {
        return this.callback;
    }

    @Override
    public final String put(Request request, Response response) throws StorageException {
        Connection conn = null;
        try {
            ResultSet rs;
            conn = this.dataSource.getConnection();
            ByteArrayInputStream content = new ByteArrayInputStream(response.getContent());
            String md5 = DigestUtils.md5Hex((InputStream)content);
            content.reset();
            HashMap<String, String> responseHeaders = new HashMap<String, String>();
            for (Header header : response.getHeaders()) {
                responseHeaders.put(header.getName(), header.getValue());
            }
            Map<String, String> requestBody = this.prepareRequestBody(request);
            PreparedStatement pstmt = conn.prepareStatement("INSERT INTO `" + this.table + "` (url, method, request_headers, request_body, status_code, response_headers, mime_type, encoding, md5, location) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", 1);
            String subDirName = md5.substring(0, 3);
            pstmt.setString(1, request.getUrl());
            pstmt.setString(2, request.getMethod().name());
            pstmt.setString(3, new JSONObject(request.getHeaders()).toString());
            pstmt.setString(4, new JSONObject(requestBody).toString());
            pstmt.setInt(5, response.getStatusCode());
            pstmt.setString(6, new JSONObject(responseHeaders).toString());
            pstmt.setString(7, response.getContentType().getMimeType());
            if (response.getContentType().getCharset() != null) {
                pstmt.setString(8, response.getContentType().getCharset().name());
            } else {
                pstmt.setString(8, null);
            }
            pstmt.setString(9, md5);
            pstmt.setString(10, subDirName);
            LOGGER.debug("Executing for: {}", (Object)request.getUrl());
            if (pstmt.executeUpdate() == 1 && (rs = pstmt.getGeneratedKeys()).next()) {
                String tryFileExtension;
                LOGGER.debug("MySQL insert successfully for: {}", (Object)request.getUrl());
                int id = rs.getInt(1);
                String sId = String.valueOf(id);
                try {
                    tryFileExtension = StorageUtil.getFileExtension(response);
                }
                catch (MimeTypeException e) {
                    LOGGER.warn("Cannot find mime type defaulting to no extension");
                    tryFileExtension = "";
                }
                String fileExtension = tryFileExtension;
                LOGGER.debug("Using extension ({}) for: {}", (Object)fileExtension, (Object)request.getUrl());
                this.createFile(content, new File(this.storagePath, subDirName), sId + fileExtension + ".gz");
                conn.commit();
                pstmt.close();
                LOGGER.debug("Record stored successfully for: {}", (Object)request.getUrl());
                String string = sId;
                return string;
            }
            try {
                conn.rollback();
                throw new StorageException("Cannot store the record");
            }
            catch (IOException | SQLException e) {
                if (conn != null) {
                    try {
                        conn.rollback();
                    }
                    catch (SQLException e2) {
                        e.addSuppressed(e2);
                        throw new StorageException("Cannot store the record", e);
                    }
                }
                throw new StorageException("Cannot store the record", e);
            }
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    throw new StorageException("Unable to close the connection", e);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final Record<Integer> get(Integer id) throws StorageException {
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement pstmt = conn.prepareStatement("SELECT * FROM `" + this.table + "` WHERE id = ?");){
            pstmt.setInt(1, id);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                StorageRecord<Integer> storageRecord = this.createRecord(rs);
                return storageRecord;
            }
        }
        catch (SQLException e) {
            LOGGER.error("Record query failure for id: {}", (Object)id, (Object)e);
            throw new StorageException("Cannot retrieve the record", e);
        }
        LOGGER.debug("No record found for id: {}", (Object)id);
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final Record<Integer> get(Request request) throws StorageException {
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement pstmt = conn.prepareStatement("SELECT * FROM `" + this.table + "` WHERE url = ? AND method = ? AND request_headers = CAST(? AS JSON) AND request_body = CAST(? AS JSON) ORDER BY `date_created` DESC ");){
            pstmt.setString(1, request.getUrl());
            pstmt.setString(2, request.getMethod().name());
            pstmt.setString(3, new JSONObject(request.getHeaders()).toString());
            pstmt.setString(4, new JSONObject(this.prepareRequestBody(request)).toString());
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                StorageRecord<Integer> storageRecord = this.createRecord(rs);
                return storageRecord;
            }
        }
        catch (SQLException e) {
            LOGGER.error("Record query failure for request: {}", (Object)request.getUrl(), (Object)e);
            throw new StorageException("Cannot retrieve the record for " + request.getUrl() + ".", e);
        }
        LOGGER.debug("No record found for request: {}", (Object)request.getUrl());
        return null;
    }

    @Override
    public final void close() throws SQLException {
        if (this.dataSource instanceof AutoCloseable) {
            try {
                ((AutoCloseable)((Object)this.dataSource)).close();
            }
            catch (SQLException e) {
                throw e;
            }
            catch (Exception e) {
                LOGGER.error("Unexpected exception during closing", (Throwable)e);
            }
        }
    }

    public static final class CompletedThreadedCallback
    implements Callback {
        private final ExecutorService executorService;
        private final FileManagerCallback fileManagerCallback;

        private CompletedThreadedCallback(FileManager fileManager) {
            this.fileManagerCallback = new FileManagerCallback(fileManager);
            this.executorService = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("FileManager I/O %d").build());
        }

        @Override
        public void completed(@NotNull Request request, @NotNull Response response) {
            this.executorService.execute(() -> this.fileManagerCallback.completed(request, response));
        }

        @Override
        public void failed(@NotNull Request request, @NotNull Exception ex) {
            this.fileManagerCallback.failed(request, ex);
        }

        @Override
        public void cancelled(@NotNull Request request) {
            this.fileManagerCallback.cancelled(request);
        }
    }
}

