/*
 * Decompiled with CFR 0.152.
 */
package ai.preferred.venom.storage;

import ai.preferred.venom.request.Request;
import ai.preferred.venom.storage.Record;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.entity.ContentType;

public final class StorageRecord<T>
implements Record<T> {
    private final T id;
    private final String url;
    private final Request.Method requestMethod;
    private final Map<String, String> requestHeaders;
    private final Map<String, String> requestBody;
    private final int statusCode;
    private final Header[] responseHeaders;
    private final ContentType contentType;
    private final byte[] responseContent;
    private final String md5;
    private final long dateCreated;

    private StorageRecord(Builder<T> builder) {
        this.id = ((Builder)builder).id;
        this.url = ((Builder)builder).url;
        this.requestMethod = ((Builder)builder).requestMethod;
        this.requestHeaders = ((Builder)builder).requestHeaders;
        this.requestBody = ((Builder)builder).requestBody;
        this.statusCode = ((Builder)builder).statusCode;
        this.responseHeaders = ((Builder)builder).responseHeaders;
        this.contentType = ((Builder)builder).contentType;
        this.responseContent = ((Builder)builder).responseContent;
        this.md5 = ((Builder)builder).md5;
        this.dateCreated = ((Builder)builder).dateCreated;
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    @Override
    public T getId() {
        return this.id;
    }

    @Override
    public String getURL() {
        return this.url;
    }

    @Override
    public Request.Method getRequestMethod() {
        return this.requestMethod;
    }

    @Override
    public Map<String, String> getRequestHeaders() {
        return this.requestHeaders;
    }

    @Override
    public Map<String, String> getRequestBody() {
        return this.requestBody;
    }

    @Override
    public int getStatusCode() {
        return this.statusCode;
    }

    @Override
    public Header[] getResponseHeaders() {
        return this.responseHeaders;
    }

    @Override
    public ContentType getContentType() {
        return this.contentType;
    }

    @Override
    public byte[] getResponseContent() {
        return this.responseContent;
    }

    @Override
    public long getDateCreated() {
        return this.dateCreated;
    }

    public String getMD5() {
        return this.md5;
    }

    public static class Builder<T> {
        private T id;
        private String url;
        private Request.Method requestMethod;
        private Map<String, String> requestHeaders;
        private Map<String, String> requestBody;
        private int statusCode;
        private Header[] responseHeaders;
        private ContentType contentType;
        private byte[] responseContent;
        private String md5;
        private long dateCreated;

        public final Builder setId(T id) {
            this.id = id;
            return this;
        }

        public final Builder setUrl(String url) {
            this.url = url;
            return this;
        }

        public final Builder setRequestMethod(Request.Method requestMethod) {
            this.requestMethod = requestMethod;
            return this;
        }

        public final Builder setRequestHeaders(Map<String, String> requestHeaders) {
            this.requestHeaders = requestHeaders;
            return this;
        }

        public final Builder setRequestBody(Map<String, String> requestBody) {
            this.requestBody = requestBody;
            return this;
        }

        public final Builder setStatusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public final Builder setResponseHeaders(Header[] responseHeaders) {
            this.responseHeaders = responseHeaders;
            return this;
        }

        public final Builder setContentType(ContentType contentType) {
            this.contentType = contentType;
            return this;
        }

        public final Builder setResponseContent(byte[] responseContent) {
            this.responseContent = responseContent;
            return this;
        }

        public final Builder setMD5(String md5) {
            this.md5 = md5;
            return this;
        }

        public final Builder setDateCreated(long dateCreated) {
            this.dateCreated = dateCreated;
            return this;
        }

        public final StorageRecord<T> build() {
            return new StorageRecord(this);
        }
    }
}

