/*
 * Decompiled with CFR 0.152.
 */
package ai.promoted.delivery.client;

import ai.promoted.delivery.client.Delivery;
import ai.promoted.delivery.client.DeliveryException;
import ai.promoted.delivery.client.DeliveryRequest;
import ai.promoted.delivery.client.InsertionFactory;
import ai.promoted.delivery.model.Insertion;
import ai.promoted.delivery.model.Paging;
import ai.promoted.delivery.model.Request;
import ai.promoted.delivery.model.Response;
import java.util.ArrayList;
import java.util.UUID;

public class SdkDelivery
implements Delivery {
    @Override
    public Response runDelivery(DeliveryRequest deliveryRequest) throws DeliveryException {
        int size;
        Request request = deliveryRequest.getRequest();
        request.setRequestId(UUID.randomUUID().toString());
        Paging paging = request.getPaging();
        if (paging == null) {
            paging = new Paging().offset(0).size(request.getInsertion().size());
        }
        int offset = paging.getOffset() != null ? Math.max(0, paging.getOffset()) : 0;
        int index = offset - deliveryRequest.getRetrievalInsertionOffset();
        if (offset < deliveryRequest.getRetrievalInsertionOffset()) {
            throw new DeliveryException("offset should be >= insertion start (specifically, the global position)");
        }
        int n = size = paging.getSize() != null ? paging.getSize() : 0;
        if (size <= 0) {
            size = request.getInsertion().size();
        }
        int finalInsertionSize = Math.min(size, request.getInsertion().size() - index);
        ArrayList<Insertion> insertionPage = new ArrayList<Insertion>(finalInsertionSize);
        for (int i = 0; i < finalInsertionSize; ++i) {
            Insertion reqIns = request.getInsertion().get(index);
            Insertion respIns = new Insertion().contentId(reqIns.getContentId());
            InsertionFactory.prepareResponseInsertion(respIns, offset);
            insertionPage.add(respIns);
            ++index;
            ++offset;
        }
        Response response = new Response();
        response.setRequestId(request.getRequestId());
        response.insertion(insertionPage);
        return response;
    }
}

