/*
 * Decompiled with CFR 0.152.
 */
package swim.auth;

import swim.api.auth.AbstractAuthenticator;
import swim.api.auth.Credentials;
import swim.api.auth.Identity;
import swim.api.policy.PolicyDirective;
import swim.auth.Authenticated;
import swim.auth.OpenIdAuthenticatorDef;
import swim.collections.FingerTrieSeq;
import swim.security.JsonWebSignature;
import swim.security.OpenIdToken;
import swim.security.PublicKeyDef;
import swim.structure.Value;
import swim.uri.Uri;

public class OpenIdAuthenticator
extends AbstractAuthenticator {
    protected final FingerTrieSeq<String> issuers;
    protected final FingerTrieSeq<String> audiences;
    protected final FingerTrieSeq<PublicKeyDef> publicKeyDefs;

    public OpenIdAuthenticator(FingerTrieSeq<String> issuers, FingerTrieSeq<String> audiences, FingerTrieSeq<PublicKeyDef> publicKeyDefs) {
        this.issuers = issuers;
        this.audiences = audiences;
        this.publicKeyDefs = publicKeyDefs;
    }

    public OpenIdAuthenticator(OpenIdAuthenticatorDef authenticatorDef) {
        this(authenticatorDef.issuers, authenticatorDef.audiences, authenticatorDef.publicKeyDefs);
    }

    public final FingerTrieSeq<String> issuers() {
        return this.issuers;
    }

    public final FingerTrieSeq<String> audiences() {
        return this.audiences;
    }

    public final FingerTrieSeq<PublicKeyDef> publicKeyDefs() {
        return this.publicKeyDefs;
    }

    public PolicyDirective<Identity> authenticate(Credentials credentials) {
        JsonWebSignature jws;
        String compactJws = credentials.claims().get("idToken").stringValue(null);
        if (compactJws == null) {
            compactJws = credentials.claims().get("openIdToken").stringValue(null);
        }
        if (compactJws != null && (jws = JsonWebSignature.parse((String)compactJws)) != null) {
            return this.authenticate(credentials.requestUri(), credentials.fromUri(), jws);
        }
        return null;
    }

    public PolicyDirective<Identity> authenticate(Uri requestUri, Uri fromUri, JsonWebSignature jws) {
        Value payloadValue = jws.payload();
        if (payloadValue.isDefined()) {
            OpenIdToken idToken = new OpenIdToken(payloadValue);
            int n = this.publicKeyDefs.size();
            for (int i = 0; i < n; ++i) {
                if (!jws.verifySignature(((PublicKeyDef)this.publicKeyDefs.get(i)).publicKey())) continue;
                return PolicyDirective.allow((Object)new Authenticated(requestUri, fromUri, idToken.toValue()));
            }
        }
        return null;
    }
}

