/*
 * Decompiled with CFR 0.152.
 */
package swim.auth;

import swim.api.auth.AuthenticatorDef;
import swim.auth.OpenIdAuthenticatorForm;
import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.collections.FingerTrieSeq;
import swim.security.PublicKeyDef;
import swim.structure.Form;
import swim.structure.Kind;
import swim.util.Murmur3;

public class OpenIdAuthenticatorDef
implements AuthenticatorDef,
Debug {
    final String authenticatorName;
    final FingerTrieSeq<String> issuers;
    final FingerTrieSeq<String> audiences;
    final FingerTrieSeq<PublicKeyDef> publicKeyDefs;
    private static int hashSeed;
    private static Form<OpenIdAuthenticatorDef> form;

    public OpenIdAuthenticatorDef(String authenticatorName, FingerTrieSeq<String> issuers, FingerTrieSeq<String> audiences, FingerTrieSeq<PublicKeyDef> publicKeyDefs) {
        this.authenticatorName = authenticatorName;
        this.issuers = issuers;
        this.audiences = audiences;
        this.publicKeyDefs = publicKeyDefs;
    }

    public final String authenticatorName() {
        return this.authenticatorName;
    }

    public final FingerTrieSeq<String> issuers() {
        return this.issuers;
    }

    public final FingerTrieSeq<String> audiences() {
        return this.audiences;
    }

    public final FingerTrieSeq<PublicKeyDef> publicKeyDefs() {
        return this.publicKeyDefs;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof OpenIdAuthenticatorDef) {
            OpenIdAuthenticatorDef that = (OpenIdAuthenticatorDef)other;
            return (this.authenticatorName == null ? that.authenticatorName == null : this.authenticatorName.equals(that.authenticatorName)) && this.issuers.equals(that.issuers) && this.audiences.equals(that.audiences) && this.publicKeyDefs.equals(that.publicKeyDefs);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(OpenIdAuthenticatorDef.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)Murmur3.hash((Object)this.authenticatorName)), (int)this.issuers.hashCode()), (int)this.audiences.hashCode()), (int)this.publicKeyDefs.hashCode()));
    }

    public void debug(Output<?> output) {
        output = output.write("new").write(32).write("OpenIdAuthenticatorDef").write(40).debug((Object)this.authenticatorName).write(", ").debug(this.issuers).write(", ").debug(this.audiences).write(", ").debug(this.publicKeyDefs).write(41);
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    @Kind
    public static Form<OpenIdAuthenticatorDef> form() {
        if (form == null) {
            form = new OpenIdAuthenticatorForm();
        }
        return form;
    }
}

