/*
 * Decompiled with CFR 0.152.
 */
package swim.auth;

import swim.auth.OpenIdAuthenticatorDef;
import swim.collections.FingerTrieSeq;
import swim.security.PublicKeyDef;
import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Record;
import swim.structure.Value;
import swim.util.Builder;

final class OpenIdAuthenticatorForm
extends Form<OpenIdAuthenticatorDef> {
    OpenIdAuthenticatorForm() {
    }

    public String tag() {
        return "openId";
    }

    public Class<?> type() {
        return OpenIdAuthenticatorDef.class;
    }

    public Item mold(OpenIdAuthenticatorDef authenticatorDef) {
        if (authenticatorDef != null) {
            Record record = Record.create().attr(this.tag());
            Value issuers = Value.absent();
            for (String issuer : authenticatorDef.issuers) {
                issuers = issuers.appended(issuer);
            }
            if (issuers.isDefined()) {
                record.slot("issuers", issuers);
            }
            Value audiences = Value.absent();
            for (String audience : authenticatorDef.audiences) {
                audiences = audiences.appended(audience);
            }
            if (audiences.isDefined()) {
                record.slot("audiences", audiences);
            }
            for (PublicKeyDef publicKeyDef : authenticatorDef.publicKeyDefs) {
                record.add((Item)publicKeyDef.toValue());
            }
            return record;
        }
        return Item.extant();
    }

    public OpenIdAuthenticatorDef cast(Item item) {
        Value value = item.toValue();
        Value headers = value.getAttr(this.tag());
        if (headers.isDefined()) {
            String authenticatorName = item.key().stringValue(null);
            Builder issuers = FingerTrieSeq.builder();
            Builder audiences = FingerTrieSeq.builder();
            Builder publicKeyDefs = FingerTrieSeq.builder();
            for (Item member : value) {
                String tag = member.tag();
                if ("issuer".equals(tag)) {
                    issuers.add((Object)member.get("issuer").stringValue());
                    continue;
                }
                if ("audience".equals(tag)) {
                    audiences.add((Object)member.get("audience").stringValue());
                    continue;
                }
                PublicKeyDef publicKeyDef = (PublicKeyDef)PublicKeyDef.publicKeyForm().cast((Item)member.toValue());
                if (publicKeyDef == null) continue;
                publicKeyDefs.add((Object)publicKeyDef);
            }
            return new OpenIdAuthenticatorDef(authenticatorName, (FingerTrieSeq<String>)((FingerTrieSeq)issuers.bind()), (FingerTrieSeq<String>)((FingerTrieSeq)audiences.bind()), (FingerTrieSeq<PublicKeyDef>)((FingerTrieSeq)publicKeyDefs.bind()));
        }
        return null;
    }
}

