/*
 * Decompiled with CFR 0.152.
 */
package swim.auth;

import swim.auth.GoogleIdAuthenticatorDef;
import swim.codec.ParserException;
import swim.collections.FingerTrieSeq;
import swim.collections.HashTrieSet;
import swim.io.http.HttpSettings;
import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Record;
import swim.structure.Value;
import swim.uri.Uri;
import swim.util.Builder;

final class GoogleIdAuthenticatorForm
extends Form<GoogleIdAuthenticatorDef> {
    GoogleIdAuthenticatorForm() {
    }

    public String tag() {
        return "googleId";
    }

    public Class<?> type() {
        return GoogleIdAuthenticatorDef.class;
    }

    public Item mold(GoogleIdAuthenticatorDef authenticatorDef) {
        if (authenticatorDef != null) {
            Record record = Record.create().attr(this.tag());
            for (String audience : authenticatorDef.audiences) {
                record.add((Item)Record.create((int)1).attr("audience", audience));
            }
            for (String email : authenticatorDef.emails) {
                record.add((Item)Record.create((int)1).attr("email", email));
            }
            return record.concat((Item)authenticatorDef.httpSettings.toValue());
        }
        return Item.extant();
    }

    public GoogleIdAuthenticatorDef cast(Item item) {
        Value value = item.toValue();
        Value headers = value.getAttr(this.tag());
        if (headers.isDefined()) {
            String authenticatorName = item.key().stringValue(null);
            Builder audiences = FingerTrieSeq.builder();
            HashTrieSet emails = HashTrieSet.empty();
            for (Item member : value) {
                String tag = member.tag();
                if ("audience".equals(tag)) {
                    audiences.add((Object)member.get("audience").stringValue());
                    continue;
                }
                if (!"email".equals(tag)) continue;
                emails = emails.added((Object)member.get("email").stringValue());
            }
            Uri publicKeyUri = null;
            try {
                publicKeyUri = Uri.parse((String)value.get("publicKeyUri").stringValue(null));
            }
            catch (NullPointerException | ParserException member) {
                // empty catch block
            }
            if (publicKeyUri == null || !publicKeyUri.isDefined()) {
                publicKeyUri = GoogleIdAuthenticatorDef.PUBLIC_KEY_URI;
            }
            HttpSettings httpSettings = (HttpSettings)HttpSettings.form().cast((Item)value);
            return new GoogleIdAuthenticatorDef(authenticatorName, (FingerTrieSeq<String>)((FingerTrieSeq)audiences.bind()), (HashTrieSet<String>)emails, publicKeyUri, httpSettings);
        }
        return null;
    }
}

