/*
 * Decompiled with CFR 0.152.
 */
package swim.codec;

import swim.codec.Base10IntegerWriter;
import swim.codec.Format;
import swim.codec.Output;
import swim.codec.StringWriter;
import swim.codec.Unicode;
import swim.codec.Writer;

public final class Base10 {
    private Base10() {
    }

    public static boolean isDigit(int c) {
        return c >= 48 && c <= 57;
    }

    public static int decodeDigit(int c) {
        if (c >= 48 && c <= 57) {
            return c - 48;
        }
        Output<String> message = Unicode.stringOutput();
        message.write("Invalid base-10 digit: ");
        Format.debugChar(c, message);
        throw new IllegalArgumentException(message.bind());
    }

    public static int encodeDigit(int b) {
        if (b >= 0 && b <= 9) {
            return 48 + b;
        }
        throw new IllegalArgumentException(Integer.toString(b));
    }

    public static int countDigits(int value) {
        int size = 0;
        do {
            ++size;
        } while ((value /= 10) != 0);
        return size;
    }

    public static int countDigits(long value) {
        int size = 0;
        do {
            ++size;
        } while ((value /= 10L) != 0L);
        return size;
    }

    public static Writer<Integer, ?> intWriter() {
        return new Base10IntegerWriter();
    }

    public static Writer<?, Integer> intWriter(int input) {
        return new Base10IntegerWriter(null, input);
    }

    public static Writer<Long, ?> longWriter() {
        return new Base10IntegerWriter();
    }

    public static Writer<?, Long> longWriter(long input) {
        return new Base10IntegerWriter(null, input);
    }

    public static Writer<?, Float> floatWriter(long input) {
        return new StringWriter(null, input);
    }

    public static Writer<?, Double> doubleWriter(long input) {
        return new StringWriter(null, input);
    }

    public static Writer<?, ?> writeInt(int input, Output<?> output) {
        return Base10IntegerWriter.write(output, null, input);
    }

    public static Writer<?, ?> writeLong(long input, Output<?> output) {
        return Base10IntegerWriter.write(output, null, input);
    }

    public static Writer<?, ?> writeFloat(float input, Output<?> output) {
        return StringWriter.write(output, null, Float.valueOf(input));
    }

    public static Writer<?, ?> writeDouble(double input, Output<?> output) {
        return StringWriter.write(output, null, input);
    }
}

