/*
 * Decompiled with CFR 0.152.
 */
package swim.codec;

import java.nio.ByteBuffer;
import swim.codec.Base64Parser;
import swim.codec.Base64Standard;
import swim.codec.Base64Url;
import swim.codec.Base64Writer;
import swim.codec.Binary;
import swim.codec.Format;
import swim.codec.Input;
import swim.codec.Output;
import swim.codec.Parser;
import swim.codec.Unicode;
import swim.codec.Writer;

public abstract class Base64 {
    private static Base64 standard;
    private static Base64 standardUnpadded;
    private static Base64 url;
    private static Base64 urlUnpadded;

    Base64() {
    }

    public abstract String alphabet();

    public abstract boolean isPadded();

    public abstract Base64 isPadded(boolean var1);

    public abstract boolean isDigit(int var1);

    public int decodeDigit(int c) {
        if (c >= 65 && c <= 90) {
            return c - 65;
        }
        if (c >= 97 && c <= 122) {
            return c + -71;
        }
        if (c >= 48 && c <= 57) {
            return c + 4;
        }
        if (c == 43 || c == 45) {
            return 62;
        }
        if (c == 47 || c == 95) {
            return 63;
        }
        Output<String> message = Unicode.stringOutput();
        message.write("Invalid base-64 digit: ");
        Format.debugChar(c, message);
        throw new IllegalArgumentException(message.bind());
    }

    public char encodeDigit(int b) {
        return this.alphabet().charAt(b);
    }

    public void writeQuantum(int c1, int c2, int c3, int c4, Output<?> output) {
        int x = this.decodeDigit(c1);
        int y = this.decodeDigit(c2);
        if (c3 != 61) {
            int z = this.decodeDigit(c3);
            if (c4 != 61) {
                int w = this.decodeDigit(c4);
                output.write(x << 2 | y >>> 4);
                output.write(y << 4 | z >>> 2);
                output.write(z << 6 | w);
            } else {
                output.write(x << 2 | y >>> 4);
                output.write(y << 4 | z >>> 2);
            }
        } else {
            if (c4 != 61) {
                throw new IllegalArgumentException("Improperly padded base-64");
            }
            output.write(x << 2 | y >>> 4);
        }
    }

    public <O> Parser<O> parser(Output<O> output) {
        return new Base64Parser<O>(output, this);
    }

    public <O> Parser<O> parse(Input input, Output<O> output) {
        return Base64Parser.parse(input, output, this);
    }

    public Parser<byte[]> parseByteArray(Input input) {
        return Base64Parser.parse(input, Binary.byteArrayOutput(), this);
    }

    public Parser<ByteBuffer> parseByteBuffer(Input input) {
        return Base64Parser.parse(input, Binary.byteBufferOutput(), this);
    }

    public Writer<byte[], ?> byteArrayWriter() {
        return new Base64Writer(this);
    }

    public Writer<?, byte[]> byteArrayWriter(byte[] input) {
        return new Base64Writer((Object)input, input, this);
    }

    public Writer<ByteBuffer, ?> byteBufferWriter() {
        return new Base64Writer(this);
    }

    public Writer<?, ByteBuffer> byteBufferWriter(ByteBuffer input) {
        return new Base64Writer((Object)input, input, this);
    }

    public Writer<?, ?> writeByteArray(byte[] input, Output<?> output) {
        return Base64Writer.write(output, input, this);
    }

    public Writer<?, ?> writeByteBuffer(ByteBuffer input, Output<?> output) {
        return Base64Writer.write(output, input, this);
    }

    public static Base64 standard() {
        if (standard == null) {
            standard = new Base64Standard(true);
        }
        return standard;
    }

    static Base64 standardUnpadded() {
        if (standardUnpadded == null) {
            standardUnpadded = new Base64Standard(false);
        }
        return standardUnpadded;
    }

    public static Base64 standard(boolean isPadded) {
        if (isPadded) {
            return Base64.standard();
        }
        return Base64.standardUnpadded();
    }

    public static Base64 url() {
        if (url == null) {
            url = new Base64Url(true);
        }
        return url;
    }

    public static Base64 urlUnpadded() {
        if (urlUnpadded == null) {
            urlUnpadded = new Base64Url(false);
        }
        return urlUnpadded;
    }

    public static Base64 url(boolean isPadded) {
        if (isPadded) {
            return Base64.url();
        }
        return Base64.urlUnpadded();
    }
}

