/*
 * Decompiled with CFR 0.152.
 */
package swim.codec;

import java.util.Objects;
import swim.codec.Base10;
import swim.codec.Display;
import swim.codec.Format;
import swim.codec.Input;
import swim.codec.Mark;
import swim.codec.Output;
import swim.codec.OutputSettings;
import swim.codec.OutputStyle;
import swim.codec.Tag;
import swim.codec.Unicode;
import swim.util.Severity;

public final class Diagnostic
implements Display {
    final Input input;
    final Tag tag;
    final Severity severity;
    final String message;
    final String note;
    final Diagnostic cause;

    Diagnostic(Input input, Tag tag, Severity severity, String message, String note, Diagnostic cause) {
        this.input = input;
        this.tag = tag;
        this.severity = severity;
        this.message = message;
        this.note = note;
        this.cause = cause;
    }

    public Input input() {
        return this.input.clone();
    }

    public Tag tag() {
        return this.tag;
    }

    public Severity severity() {
        return this.severity;
    }

    public String message() {
        return this.message;
    }

    public String note() {
        return this.note;
    }

    public Diagnostic cause() {
        return this.cause;
    }

    private int lineDigits() {
        int digits = Base10.countDigits(this.tag.end().line());
        if (this.cause != null) {
            digits = Math.max(digits, this.cause.lineDigits());
        }
        return digits;
    }

    @Override
    public void display(Output<?> output) {
        Input input = this.input.clone();
        Mark start = this.tag.start();
        Mark end = this.tag.end();
        Severity severity = this.severity;
        String message = this.message;
        String note = this.note;
        Diagnostic cause = this.cause;
        int contextLines = 2;
        int lineDigits = this.lineDigits();
        Diagnostic.displayDiagnostic(input, start, end, severity, message, note, cause, 2, lineDigits, output);
    }

    public String toString(OutputSettings settings) {
        return Format.display((Object)this, settings);
    }

    public String toString() {
        return Format.display(this);
    }

    public static Diagnostic from(Input input, Tag tag, Severity severity, String message, String note, Diagnostic cause) {
        input = input.clone();
        tag = Objects.requireNonNull(tag);
        severity = Objects.requireNonNull(severity);
        return new Diagnostic(input, tag, severity, message, note, cause);
    }

    public static Diagnostic from(Input input, Tag tag, Severity severity, String message, String note) {
        return Diagnostic.from(input, tag, severity, message, note, null);
    }

    public static Diagnostic from(Input input, Tag tag, Severity severity, String message, Diagnostic cause) {
        return Diagnostic.from(input, tag, severity, message, null, cause);
    }

    public static Diagnostic from(Input input, Tag tag, Severity severity, String message) {
        return Diagnostic.from(input, tag, severity, message, null, null);
    }

    public static Diagnostic from(Input input, Tag tag, Severity severity, Diagnostic cause) {
        return Diagnostic.from(input, tag, severity, null, null, cause);
    }

    public static Diagnostic from(Input input, Tag tag, Severity severity) {
        return Diagnostic.from(input, tag, severity, null, null, null);
    }

    public static Diagnostic message(String message, Input input, Severity severity, String note, Diagnostic cause) {
        Mark mark = input.mark();
        Input source = input.clone().seek(null);
        return Diagnostic.from(source, mark, severity, message, note, cause);
    }

    public static Diagnostic message(String message, Input input, Severity severity, String note) {
        return Diagnostic.message(message, input, severity, note, null);
    }

    public static Diagnostic message(String message, Input input, Severity severity, Diagnostic cause) {
        return Diagnostic.message(message, input, severity, null, cause);
    }

    public static Diagnostic message(String message, Input input, Severity severity) {
        return Diagnostic.message(message, input, severity, null, null);
    }

    public static Diagnostic message(String message, Input input, String note, Diagnostic cause) {
        return Diagnostic.message(message, input, Severity.error(), note, cause);
    }

    public static Diagnostic message(String message, Input input, String note) {
        return Diagnostic.message(message, input, Severity.error(), note, null);
    }

    public static Diagnostic message(String message, Input input, Diagnostic cause) {
        return Diagnostic.message(message, input, Severity.error(), null, cause);
    }

    public static Diagnostic message(String message, Input input) {
        return Diagnostic.message(message, input, Severity.error(), null, null);
    }

    public static Diagnostic unexpected(Input input, Severity severity, String note, Diagnostic cause) {
        String message;
        if (input.isCont()) {
            Output<String> output = Unicode.stringOutput().write("unexpected").write(32);
            Format.debugChar(input.head(), output);
            message = output.bind();
        } else {
            message = "unexpected end of input";
        }
        Mark mark = input.mark();
        Input source = input.clone().seek(null);
        return Diagnostic.from(source, mark, severity, message, note, cause);
    }

    public static Diagnostic unexpected(Input input, Severity severity, String note) {
        return Diagnostic.unexpected(input, severity, note, null);
    }

    public static Diagnostic unexpected(Input input, Severity severity, Diagnostic cause) {
        return Diagnostic.unexpected(input, severity, null, cause);
    }

    public static Diagnostic unexpected(Input input, Severity severity) {
        return Diagnostic.unexpected(input, severity, null, null);
    }

    public static Diagnostic unexpected(Input input, String note, Diagnostic cause) {
        return Diagnostic.unexpected(input, Severity.error(), note, cause);
    }

    public static Diagnostic unexpected(Input input, String note) {
        return Diagnostic.unexpected(input, Severity.error(), note, null);
    }

    public static Diagnostic unexpected(Input input, Diagnostic cause) {
        return Diagnostic.unexpected(input, Severity.error(), null, cause);
    }

    public static Diagnostic unexpected(Input input) {
        return Diagnostic.unexpected(input, Severity.error(), null, null);
    }

    public static Diagnostic expected(int expected, Input input, Severity severity, String note, Diagnostic cause) {
        Output<String> output = Unicode.stringOutput().write("expected").write(32);
        Format.debugChar(expected, output);
        output = output.write(", ").write("but found").write(32);
        if (input.isCont()) {
            Format.debugChar(input.head(), output);
        } else {
            output = output.write("end of input");
        }
        String message = output.bind();
        Mark mark = input.mark();
        Input source = input.clone().seek(null);
        return Diagnostic.from(source, mark, severity, message, note, cause);
    }

    public static Diagnostic expected(int expected, Input input, Severity severity, String note) {
        return Diagnostic.expected(expected, input, severity, note, null);
    }

    public static Diagnostic expected(int expected, Input input, Severity severity, Diagnostic cause) {
        return Diagnostic.expected(expected, input, severity, null, cause);
    }

    public static Diagnostic expected(int expected, Input input, Severity severity) {
        return Diagnostic.expected(expected, input, severity, null, null);
    }

    public static Diagnostic expected(int expected, Input input, String note, Diagnostic cause) {
        return Diagnostic.expected(expected, input, Severity.error(), note, cause);
    }

    public static Diagnostic expected(int expected, Input input, String note) {
        return Diagnostic.expected(expected, input, Severity.error(), note, null);
    }

    public static Diagnostic expected(int expected, Input input, Diagnostic cause) {
        return Diagnostic.expected(expected, input, Severity.error(), null, cause);
    }

    public static Diagnostic expected(int expected, Input input) {
        return Diagnostic.expected(expected, input, Severity.error(), null, null);
    }

    public static Diagnostic expected(String expected, Input input, Severity severity, String note, Diagnostic cause) {
        Output<String> output = Unicode.stringOutput().write("expected").write(32).write(expected).write(", ").write("but found").write(32);
        if (input.isCont()) {
            Format.debugChar(input.head(), output);
        } else {
            output = output.write("end of input");
        }
        String message = output.bind();
        Mark mark = input.mark();
        Input source = input.clone().seek(null);
        return Diagnostic.from(source, mark, severity, message, note, cause);
    }

    public static Diagnostic expected(String expected, Input input, Severity severity, String note) {
        return Diagnostic.expected(expected, input, severity, note, null);
    }

    public static Diagnostic expected(String expected, Input input, Severity severity, Diagnostic cause) {
        return Diagnostic.expected(expected, input, severity, null, cause);
    }

    public static Diagnostic expected(String expected, Input input, Severity severity) {
        return Diagnostic.expected(expected, input, severity, null, null);
    }

    public static Diagnostic expected(String expected, Input input, String note, Diagnostic cause) {
        return Diagnostic.expected(expected, input, Severity.error(), note, cause);
    }

    public static Diagnostic expected(String expected, Input input, String note) {
        return Diagnostic.expected(expected, input, Severity.error(), note, null);
    }

    public static Diagnostic expected(String expected, Input input, Diagnostic cause) {
        return Diagnostic.expected(expected, input, Severity.error(), null, cause);
    }

    public static Diagnostic expected(String expected, Input input) {
        return Diagnostic.expected(expected, input, Severity.error(), null, null);
    }

    static void displayDiagnostic(Input input, Mark start, Mark end, Severity severity, String message, String note, Diagnostic cause, int contextLines, int lineDigits, Output<?> output) {
        while (true) {
            if (message != null) {
                Diagnostic.displayMessage(severity, message, output);
                output = output.writeln();
            }
            Diagnostic.displayAnchor(input, start, lineDigits, output);
            output = output.writeln();
            Diagnostic next = Diagnostic.displayContext(input, start, end, severity, note, cause, contextLines, lineDigits, output);
            if (next == null) break;
            output = output.writeln();
            input = next.input.clone();
            start = next.tag.start();
            end = next.tag.end();
            severity = next.severity;
            message = next.message;
            note = next.note;
            cause = next.cause;
        }
    }

    static void displayMessage(Severity severity, String message, Output<?> output) {
        Diagnostic.formatSeverity(severity, output);
        output = output.write(severity.label());
        OutputStyle.reset(output);
        OutputStyle.bold(output);
        output = output.write(58);
        if (message != null) {
            output = output.write(32).write(message);
        }
        OutputStyle.reset(output);
    }

    static void displayAnchor(Input input, Mark start, int lineDigits, Output<?> output) {
        Diagnostic.displayLineLeadArrow(lineDigits, output);
        output = output.write(32);
        Object id = input.id();
        if (id != null) {
            Format.display(id, output);
        }
        output = output.write(58);
        Format.displayInt(start.line, output);
        output = output.write(58);
        Format.displayInt(start.column, output);
        output = output.writeln();
        Diagnostic.displayLineLead(lineDigits, output);
    }

    static Diagnostic displayCause(Diagnostic cause, int contextLines, int lineDigits, Output<?> output) {
        Input input = cause.input.clone();
        Mark start = cause.tag.start();
        Mark end = cause.tag.end();
        Severity severity = cause.severity;
        String note = cause.note;
        Diagnostic next = cause.cause;
        return Diagnostic.displayContext(input, start, end, severity, note, next, contextLines, lineDigits, output);
    }

    static Diagnostic displayContext(Input input, Mark start, Mark end, Severity severity, String note, Diagnostic cause, int contextLines, int lineDigits, Output<?> output) {
        int causeOrder;
        boolean sameCause;
        Diagnostic next = cause;
        boolean bl = sameCause = cause != null && cause.message == null && Objects.equals(input.id(), cause.input.id());
        int n = sameCause ? (start.offset <= cause.tag.start().offset ? -1 : 1) : (causeOrder = 0);
        if (causeOrder == 1) {
            next = Diagnostic.displayCause(cause, contextLines, lineDigits, output);
            output = output.writeln();
            Diagnostic.displayLineLeadEllipsis(lineDigits, output);
            output = output.writeln();
        }
        Diagnostic.displayLines(input, start, end, severity, contextLines, lineDigits, output);
        if (note != null) {
            Diagnostic.displayNote(note, lineDigits, output);
        }
        if (causeOrder == -1) {
            output = output.writeln();
            Diagnostic.displayLineLeadEllipsis(lineDigits, output);
            output = output.writeln();
            next = Diagnostic.displayCause(cause, contextLines, lineDigits, output);
        }
        return next;
    }

    static void displayLines(Input input, Mark start, Mark end, Severity severity, int contextLines, int lineDigits, Output<?> output) {
        int line;
        int startLine = start.line();
        int endLine = end.line();
        for (line = input.line(); line < startLine; ++line) {
            Diagnostic.consumeLineText(input, line);
        }
        if (endLine - startLine > 2 * contextLines + 2) {
            while (line <= startLine + contextLines) {
                Diagnostic.displayLine(input, start, end, severity, line, lineDigits, output);
                ++line;
            }
            Diagnostic.displayLineLeadEllipsis(lineDigits, output);
            output = output.write(32);
            Diagnostic.formatSeverity(severity, output);
            output = output.write(124);
            OutputStyle.reset(output);
            output = output.writeln();
            while (line < endLine - contextLines) {
                Diagnostic.consumeLineText(input, line);
                ++line;
            }
        }
        while (line <= endLine) {
            Diagnostic.displayLine(input, start, end, severity, line, lineDigits, output);
            ++line;
        }
    }

    static void displayNote(String note, int lineDigits, Output<?> output) {
        output = output.writeln();
        Diagnostic.displayLineLead(lineDigits, output);
        output = output.writeln();
        Diagnostic.displayLineComment("note", note, lineDigits, output);
    }

    static void displayLine(Input input, Mark start, Mark end, Severity severity, int line, int lineDigits, Output<?> output) {
        if (start.line == line && end.line == line) {
            Diagnostic.displaySingleLine(input, start, end, severity, line, lineDigits, output);
        } else if (start.line == line) {
            Diagnostic.displayStartLine(input, start, severity, line, lineDigits, output);
        } else if (end.line == line) {
            Diagnostic.displayEndLine(input, end, severity, line, lineDigits, output);
        } else {
            Diagnostic.displayMidLine(input, severity, line, lineDigits, output);
        }
    }

    static void displaySingleLine(Input input, Mark start, Mark end, Severity severity, int line, int lineDigits, Output<?> output) {
        int i;
        Diagnostic.displayLineLeadNumber(line, lineDigits, output);
        output = output.write(32);
        for (i = 1; i < input.column(); ++i) {
            output = output.write(32);
        }
        Diagnostic.displayLineText(input, line, output);
        Diagnostic.displayLineLead(lineDigits, output);
        output = output.write(32);
        for (i = 1; i < start.column; ++i) {
            output = output.write(32);
        }
        Diagnostic.formatSeverity(severity, output);
        while (i <= end.column) {
            output = output.write(94);
            ++i;
        }
        if (end.note != null) {
            output = output.write(32).write(end.note);
        }
        OutputStyle.reset(output);
    }

    static void displayStartLine(Input input, Mark start, Severity severity, int line, int lineDigits, Output<?> output) {
        int i;
        Diagnostic.displayLineLeadNumber(line, lineDigits, output);
        output = output.write(32).write(32).write(32);
        for (i = 1; i < input.column(); ++i) {
            output = output.write(32);
        }
        Diagnostic.displayLineText(input, line, output);
        Diagnostic.displayLineLead(lineDigits, output);
        output = output.write(32).write(32);
        Diagnostic.formatSeverity(severity, output);
        output = output.write(95);
        for (i = 1; i < start.column; ++i) {
            output = output.write(95);
        }
        output = output.write(94);
        if (start.note != null) {
            output = output.write(32).write(start.note);
        }
        OutputStyle.reset(output);
        output = output.writeln();
    }

    static void displayEndLine(Input input, Mark end, Severity severity, int line, int lineDigits, Output<?> output) {
        Diagnostic.displayLineLeadNumber(line, lineDigits, output);
        output = output.write(32);
        Diagnostic.formatSeverity(severity, output);
        output = output.write(124);
        OutputStyle.reset(output);
        output = output.write(32);
        Diagnostic.displayLineText(input, line, output);
        Diagnostic.displayLineLead(lineDigits, output);
        output = output.write(32);
        Diagnostic.formatSeverity(severity, output);
        output = output.write(124).write(95);
        for (int i = 1; i < end.column; ++i) {
            output = output.write(95);
        }
        output = output.write(94);
        if (end.note != null) {
            output = output.write(32).write(end.note);
        }
        OutputStyle.reset(output);
    }

    static void displayMidLine(Input input, Severity severity, int line, int lineDigits, Output<?> output) {
        Diagnostic.displayLineLeadNumber(line, lineDigits, output);
        output = output.write(32);
        Diagnostic.formatSeverity(severity, output);
        output = output.write(124);
        OutputStyle.reset(output);
        output = output.write(32);
        Diagnostic.displayLineText(input, line, output);
    }

    static void displayLineComment(String label, String comment, int lineDigits, Output<?> output) {
        Diagnostic.displayLineLeadComment(lineDigits, output);
        output = output.write(32);
        OutputStyle.bold(output);
        output = output.write(label).write(58);
        OutputStyle.reset(output);
        if (comment != null) {
            output = output.write(32).write(comment);
        }
    }

    static void displayLineLead(int lineDigits, Output<?> output) {
        OutputStyle.blueBold(output);
        int padding = 1 + lineDigits;
        for (int i = 0; i < padding; ++i) {
            output = output.write(32);
        }
        output = output.write(124);
        OutputStyle.reset(output);
    }

    static void displayLineLeadComment(int lineDigits, Output<?> output) {
        OutputStyle.blueBold(output);
        int padding = 1 + lineDigits;
        for (int i = 0; i < padding; ++i) {
            output = output.write(32);
        }
        output = output.write(61);
        OutputStyle.reset(output);
    }

    static void displayLineLeadArrow(int lineDigits, Output<?> output) {
        for (int i = 0; i < lineDigits; ++i) {
            output = output.write(32);
        }
        OutputStyle.blueBold(output);
        output = output.write(45).write(45).write(62);
        OutputStyle.reset(output);
    }

    static void displayLineLeadEllipsis(int lineDigits, Output<?> output) {
        OutputStyle.blueBold(output);
        for (int i = 0; i < lineDigits; ++i) {
            output = output.write(46);
        }
        OutputStyle.reset(output);
        output = output.write(32).write(32);
    }

    static void displayLineLeadNumber(int line, int lineDigits, Output<?> output) {
        int padding = lineDigits - Base10.countDigits(line);
        for (int i = 0; i < padding; ++i) {
            output = output.write(32);
        }
        OutputStyle.blueBold(output);
        Format.displayInt(line, output);
        output = output.write(32).write(124);
        OutputStyle.reset(output);
    }

    static void displayLineText(Input input, int line, Output<?> output) {
        while (input.isCont() && input.line() == line) {
            output = output.write(input.head());
            input = input.step();
        }
        if (input.line() == line) {
            output = output.writeln();
        }
    }

    static void consumeLineText(Input input, int line) {
        while (input.isCont() && input.line() == line) {
            input = input.step();
        }
    }

    static void formatSeverity(Severity severity, Output<?> output) {
        switch (severity.level()) {
            case 5: 
            case 6: 
            case 7: {
                OutputStyle.redBold(output);
                break;
            }
            case 4: {
                OutputStyle.yellowBold(output);
                break;
            }
            case 3: {
                OutputStyle.greenBold(output);
                break;
            }
            case 2: {
                OutputStyle.cyanBold(output);
                break;
            }
            default: {
                OutputStyle.magentaBold(output);
            }
        }
    }
}

