/*
 * Decompiled with CFR 0.152.
 */
package swim.uri;

import java.util.Collection;
import java.util.Map;
import swim.codec.Base16;
import swim.codec.Debug;
import swim.codec.Display;
import swim.codec.Format;
import swim.codec.Output;
import swim.structure.Form;
import swim.structure.Kind;
import swim.uri.UriAuthority;
import swim.uri.UriException;
import swim.uri.UriForm;
import swim.uri.UriFragment;
import swim.uri.UriHost;
import swim.uri.UriParser;
import swim.uri.UriPath;
import swim.uri.UriPort;
import swim.uri.UriQuery;
import swim.uri.UriScheme;
import swim.uri.UriUser;

public class Uri
implements Comparable<Uri>,
Debug,
Display {
    protected final UriScheme scheme;
    protected final UriAuthority authority;
    protected final UriPath path;
    protected final UriQuery query;
    protected final UriFragment fragment;
    String string;
    private static Uri empty;
    private static UriParser standardParser;
    private static Form<Uri> form;

    protected Uri(UriScheme scheme, UriAuthority authority, UriPath path, UriQuery query, UriFragment fragment) {
        this.scheme = scheme;
        this.authority = authority;
        this.path = path;
        this.query = query;
        this.fragment = fragment;
    }

    public final boolean isDefined() {
        return this.scheme.isDefined() || this.authority.isDefined() || this.path.isDefined() || this.query.isDefined() || this.fragment.isDefined();
    }

    public final boolean isEmpty() {
        return !this.scheme.isDefined() && !this.authority.isDefined() && this.path.isEmpty() && !this.query.isDefined() && !this.fragment.isDefined();
    }

    public final UriScheme scheme() {
        return this.scheme;
    }

    public Uri scheme(UriScheme scheme) {
        if (scheme != this.scheme) {
            return this.copy(scheme, this.authority, this.path, this.query, this.fragment);
        }
        return this;
    }

    public final String schemePart() {
        return this.scheme.toString();
    }

    public Uri schemePart(String scheme) {
        return this.scheme(UriScheme.parse(scheme));
    }

    public final String schemeName() {
        return this.scheme.name();
    }

    public Uri schemeName(String scheme) {
        return this.scheme(UriScheme.from(scheme));
    }

    public final UriAuthority authority() {
        return this.authority;
    }

    public Uri authority(UriAuthority authority) {
        if (authority != this.authority) {
            return this.copy(this.scheme, authority, this.path, this.query, this.fragment);
        }
        return this;
    }

    public final String authorityPart() {
        return this.authority.toString();
    }

    public Uri authorityPart(String authority) {
        return this.authority(UriAuthority.parse(authority));
    }

    public final UriUser user() {
        return this.authority.user();
    }

    public Uri user(UriUser user) {
        return this.authority(this.authority.user(user));
    }

    public final String userPart() {
        return this.authority.userPart();
    }

    public Uri userPart(String user) {
        return this.authority(this.authority.userPart(user));
    }

    public String username() {
        return this.authority.username();
    }

    public Uri username(String username) {
        return this.authority(this.authority.username(username));
    }

    public Uri username(String username, String password) {
        return this.authority(this.authority.username(username, password));
    }

    public String password() {
        return this.authority.password();
    }

    public Uri password(String password) {
        return this.authority(this.authority.password(password));
    }

    public final UriHost host() {
        return this.authority.host();
    }

    public Uri host(UriHost host) {
        return this.authority(this.authority.host(host));
    }

    public final String hostPart() {
        return this.authority.hostPart();
    }

    public Uri hostPart(String host) {
        return this.authority(this.authority.hostPart(host));
    }

    public final String hostAddress() {
        return this.authority.hostAddress();
    }

    public final String hostName() {
        return this.authority.hostName();
    }

    public Uri hostName(String address) {
        return this.authority(this.authority.hostName(address));
    }

    public final String hostIPv4() {
        return this.authority.hostIPv4();
    }

    public Uri hostIPv4(String address) {
        return this.authority(this.authority.hostIPv4(address));
    }

    public final String hostIPv6() {
        return this.authority.hostIPv6();
    }

    public Uri hostIPv6(String address) {
        return this.authority(this.authority.hostIPv6(address));
    }

    public final UriPort port() {
        return this.authority.port();
    }

    public Uri port(UriPort port) {
        return this.authority(this.authority.port(port));
    }

    public final String portPart() {
        return this.authority.portPart();
    }

    public Uri portPart(String port) {
        return this.authority(this.authority.portPart(port));
    }

    public final int portNumber() {
        return this.authority.portNumber();
    }

    public Uri portNumber(int number) {
        return this.authority(this.authority.portNumber(number));
    }

    public final UriPath path() {
        return this.path;
    }

    public Uri path(UriPath path) {
        if (path != this.path) {
            return this.copy(this.scheme, this.authority, path, this.query, this.fragment);
        }
        return this;
    }

    public Uri path(String ... components) {
        return this.path(UriPath.from(components));
    }

    public final String pathPart() {
        return this.path.toString();
    }

    public Uri pathPart(String path) {
        return this.path(UriPath.parse(path));
    }

    public final String pathName() {
        return this.path.name();
    }

    public Uri appendedPath(String component) {
        return this.path(this.path.appended(component));
    }

    public Uri appendedPath(String ... components) {
        return this.path(this.path.appended(components));
    }

    public Uri appendedPath(Collection<? extends String> components) {
        return this.path(this.path.appended(components));
    }

    public Uri appendedSlash() {
        return this.path(this.path.appendedSlash());
    }

    public Uri appendedSegment(String segment) {
        return this.path(this.path.appendedSegment(segment));
    }

    public Uri prependedPath(String component) {
        return this.path(this.path.prepended(component));
    }

    public Uri prependedPath(String ... components) {
        return this.path(this.path.prepended(components));
    }

    public Uri prependedPath(Collection<? extends String> components) {
        return this.path(this.path.prepended(components));
    }

    public Uri prependedSlash() {
        return this.path(this.path.prependedSlash());
    }

    public Uri prependedSegment(String segment) {
        return this.path(this.path.prependedSegment(segment));
    }

    public final UriQuery query() {
        return this.query;
    }

    public Uri query(UriQuery query) {
        if (query != this.query) {
            return this.copy(this.scheme, this.authority, this.path, query, this.fragment);
        }
        return this;
    }

    public Uri query(String ... keyValuePairs) {
        return this.query(UriQuery.from(keyValuePairs));
    }

    public final String queryPart() {
        return this.query.toString();
    }

    public Uri queryPart(String query) {
        return this.query(UriQuery.parse(query));
    }

    public Uri updatedQuery(String key, String value) {
        return this.query(this.query.updated(key, value));
    }

    public Uri removedQuery(String key) {
        return this.query(this.query.removed(key));
    }

    public Uri appendedQuery(String value) {
        return this.query(this.query.appended(value));
    }

    public Uri appendedQuery(String key, String value) {
        return this.query(this.query.appended(key, value));
    }

    public Uri appendedQuery(String ... keyValuePairs) {
        return this.query(this.query.appended(keyValuePairs));
    }

    public Uri appendedQuery(Map<? extends String, ? extends String> params) {
        return this.query(this.query.appended(params));
    }

    public Uri prependedQuery(String value) {
        return this.query(this.query.prepended(value));
    }

    public Uri prependedQuery(String key, String value) {
        return this.query(this.query.prepended(key, value));
    }

    public Uri prependedQuery(String ... keyValuePairs) {
        return this.query(this.query.prepended(keyValuePairs));
    }

    public Uri prependedQuery(Map<? extends String, ? extends String> params) {
        return this.query(this.query.prepended(this.query));
    }

    public final UriFragment fragment() {
        return this.fragment;
    }

    public Uri fragment(UriFragment fragment) {
        if (fragment != this.fragment) {
            return this.copy(this.scheme, this.authority, this.path, this.query, fragment);
        }
        return this;
    }

    public final String fragmentPart() {
        return this.fragment.toString();
    }

    public Uri fragmentPart(String fragment) {
        return this.fragment(UriFragment.parse(fragment));
    }

    public final String fragmentIdentifier() {
        return this.fragment.identifier();
    }

    public Uri fragmentIdentifier(String fragment) {
        return this.fragment(UriFragment.from(fragment));
    }

    public Uri resolve(Uri relative) {
        if (relative.scheme.isDefined()) {
            return this.copy(relative.scheme, relative.authority, relative.path.removeDotSegments(), relative.query, relative.fragment);
        }
        if (relative.authority.isDefined()) {
            return this.copy(this.scheme, relative.authority, relative.path.removeDotSegments(), relative.query, relative.fragment);
        }
        if (relative.path.isEmpty()) {
            return this.copy(this.scheme, this.authority, this.path, relative.query.isDefined() ? relative.query : this.query, relative.fragment);
        }
        if (relative.path.isAbsolute()) {
            return this.copy(this.scheme, this.authority, relative.path.removeDotSegments(), relative.query, relative.fragment);
        }
        return this.copy(this.scheme, this.authority, this.merge(relative.path).removeDotSegments(), relative.query, relative.fragment);
    }

    protected UriPath merge(UriPath relative) {
        if (this.authority.isDefined() && this.path.isEmpty()) {
            return relative.prependedSlash();
        }
        if (this.path.isEmpty()) {
            return relative;
        }
        return this.path.merge(relative);
    }

    public Uri unresolve(Uri absolute) {
        if (!this.scheme.equals(absolute.scheme) || !this.authority.equals(absolute.authority)) {
            return absolute;
        }
        return this.copy(UriScheme.undefined(), UriAuthority.undefined(), this.path.unmerge(absolute.path), absolute.query, absolute.fragment);
    }

    protected Uri copy(UriScheme scheme, UriAuthority authority, UriPath path, UriQuery query, UriFragment fragment) {
        return Uri.from(scheme, authority, path, query, fragment);
    }

    @Override
    public final int compareTo(Uri that) {
        return this.toString().compareTo(that.toString());
    }

    public final boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Uri) {
            return this.toString().equals(((Uri)other).toString());
        }
        return false;
    }

    public final int hashCode() {
        return this.toString().hashCode();
    }

    public void debug(Output<?> output) {
        output = output.write("Uri").write(46);
        output = this.isDefined() ? output.write("parse").write(40).write(34).display((Object)this).write(34).write(41) : output.write("empty").write(40).write(41);
    }

    public void display(Output<?> output) {
        if (this.string != null) {
            output = output.write(this.string);
        } else {
            if (this.scheme.isDefined()) {
                output.display((Object)this.scheme).write(58);
            }
            if (this.authority.isDefined()) {
                output = output.write(47).write(47).display((Object)this.authority);
            }
            output.display((Object)this.path);
            if (this.query.isDefined()) {
                output = output.write(63).display((Object)this.query);
            }
            if (this.fragment.isDefined()) {
                output = output.write(35).display((Object)this.fragment);
            }
        }
    }

    public final String toString() {
        if (this.string == null) {
            this.string = Format.display((Object)this);
        }
        return this.string;
    }

    public static Uri empty() {
        if (empty == null) {
            empty = new Uri(UriScheme.undefined(), UriAuthority.undefined(), UriPath.empty(), UriQuery.undefined(), UriFragment.undefined());
        }
        return empty;
    }

    public static Uri from(UriScheme scheme, UriAuthority authority, UriPath path, UriQuery query, UriFragment fragment) {
        if (scheme == null) {
            scheme = UriScheme.undefined();
        }
        if (authority == null) {
            authority = UriAuthority.undefined();
        }
        if (path == null) {
            path = UriPath.empty();
        }
        if (query == null) {
            query = UriQuery.undefined();
        }
        if (fragment == null) {
            fragment = UriFragment.undefined();
        }
        if (scheme.isDefined() || authority.isDefined() || path.isDefined() || query.isDefined() || fragment.isDefined()) {
            return new Uri(scheme, authority, path, query, fragment);
        }
        return Uri.empty();
    }

    public static Uri from(UriScheme scheme, UriAuthority authority, UriPath path, UriQuery query) {
        return Uri.from(scheme, authority, path, query, null);
    }

    public static Uri from(UriScheme scheme, UriAuthority authority, UriPath path, UriFragment fragment) {
        return Uri.from(scheme, authority, path, null, fragment);
    }

    public static Uri from(UriScheme scheme, UriAuthority authority, UriPath path) {
        return Uri.from(scheme, authority, path, null, null);
    }

    public static Uri from(UriScheme scheme, UriAuthority authority) {
        return Uri.from(scheme, authority, null, null, null);
    }

    public static Uri from(UriPath path, UriQuery query, UriFragment fragment) {
        return Uri.from(null, null, path, query, fragment);
    }

    public static Uri from(UriPath path, UriQuery query) {
        return Uri.from(null, null, path, query, null);
    }

    public static Uri from(UriPath path, UriFragment fragment) {
        return Uri.from(null, null, path, null, fragment);
    }

    public static Uri from(UriPath path) {
        return Uri.from(null, null, path, null, null);
    }

    public static UriParser standardParser() {
        if (standardParser == null) {
            standardParser = new UriParser();
        }
        return standardParser;
    }

    public static Uri parse(String string) {
        return Uri.standardParser().parseAbsoluteString(string);
    }

    static boolean isUnreservedChar(int c) {
        return c >= 65 && c <= 90 || c >= 97 && c <= 122 || c >= 48 && c <= 57 || c == 45 || c == 46 || c == 95 || c == 126;
    }

    static boolean isSubDelimChar(int c) {
        return c == 33 || c == 36 || c == 38 || c == 40 || c == 41 || c == 42 || c == 43 || c == 44 || c == 59 || c == 61 || c == 39;
    }

    static boolean isSchemeChar(int c) {
        return c >= 65 && c <= 90 || c >= 97 && c <= 122 || c >= 48 && c <= 57 || c == 43 || c == 45 || c == 46;
    }

    static boolean isUserInfoChar(int c) {
        return Uri.isUnreservedChar(c) || Uri.isSubDelimChar(c) || c == 58;
    }

    static boolean isUserChar(int c) {
        return Uri.isUnreservedChar(c) || Uri.isSubDelimChar(c);
    }

    static boolean isHostChar(int c) {
        return Uri.isUnreservedChar(c) || Uri.isSubDelimChar(c);
    }

    static boolean isPathChar(int c) {
        return Uri.isUnreservedChar(c) || Uri.isSubDelimChar(c) || c == 58 || c == 64;
    }

    static boolean isQueryChar(int c) {
        return Uri.isUnreservedChar(c) || Uri.isSubDelimChar(c) || c == 47 || c == 58 || c == 63 || c == 64;
    }

    static boolean isParamChar(int c) {
        return Uri.isUnreservedChar(c) || c == 33 || c == 36 || c == 40 || c == 41 || c == 42 || c == 43 || c == 44 || c == 47 || c == 58 || c == 59 || c == 63 || c == 64 || c == 39;
    }

    static boolean isFragmentChar(int c) {
        return Uri.isUnreservedChar(c) || Uri.isSubDelimChar(c) || c == 47 || c == 58 || c == 63 || c == 64;
    }

    static boolean isAlpha(int c) {
        return c >= 65 && c <= 90 || c >= 97 && c <= 122;
    }

    static void writeScheme(String scheme, Output<?> output) {
        int n = scheme.length();
        int i = 0;
        while (i < n) {
            int c = scheme.codePointAt(i);
            if (!(i > 0 && Uri.isSchemeChar(c) || i == 0 && Uri.isAlpha(c))) {
                throw new UriException("Invalid scheme: " + scheme);
            }
            output = output.write(c);
            i = scheme.offsetByCodePoints(i, 1);
        }
    }

    static void writeUserInfo(String userInfo, Output<?> output) {
        int n = userInfo.length();
        int i = 0;
        while (i < n) {
            int c = userInfo.codePointAt(i);
            if (Uri.isUserInfoChar(c)) {
                output = output.write(c);
            } else {
                Uri.writeEncoded(c, output);
            }
            i = userInfo.offsetByCodePoints(i, 1);
        }
    }

    static void writeUser(String user, Output<?> output) {
        int n = user.length();
        int i = 0;
        while (i < n) {
            int c = user.codePointAt(i);
            if (Uri.isUserChar(c)) {
                output = output.write(c);
            } else {
                Uri.writeEncoded(c, output);
            }
            i = user.offsetByCodePoints(i, 1);
        }
    }

    static void writeHost(String address, Output<?> output) {
        int n = address.length();
        int i = 0;
        while (i < n) {
            int c = address.codePointAt(i);
            if (Uri.isHostChar(c)) {
                output = output.write(c);
            } else {
                Uri.writeEncoded(c, output);
            }
            i = address.offsetByCodePoints(i, 1);
        }
    }

    static void writeHostLiteral(String address, Output<?> output) {
        int n = address.length();
        int i = 0;
        while (i < n) {
            int c = address.codePointAt(i);
            if (Uri.isHostChar(c) || c == 58) {
                output = output.write(c);
            } else {
                Uri.writeEncoded(c, output);
            }
            i = address.offsetByCodePoints(i, 1);
        }
    }

    static void writePathSegment(String segment, Output<?> output) {
        int n = segment.length();
        int i = 0;
        while (i < n) {
            int c = segment.codePointAt(i);
            if (Uri.isPathChar(c)) {
                output = output.write(c);
            } else {
                Uri.writeEncoded(c, output);
            }
            i = segment.offsetByCodePoints(i, 1);
        }
    }

    static void writeQuery(String query, Output<?> output) {
        int n = query.length();
        int i = 0;
        while (i < n) {
            int c = query.codePointAt(i);
            if (Uri.isQueryChar(c)) {
                output = output.write(c);
            } else {
                Uri.writeEncoded(c, output);
            }
            i = query.offsetByCodePoints(i, 1);
        }
    }

    static void writeParam(String param, Output<?> output) {
        int n = param.length();
        int i = 0;
        while (i < n) {
            int c = param.codePointAt(i);
            if (Uri.isParamChar(c)) {
                output = output.write(c);
            } else {
                Uri.writeEncoded(c, output);
            }
            i = param.offsetByCodePoints(i, 1);
        }
    }

    static void writeFragment(String fragment, Output<?> output) {
        int n = fragment.length();
        int i = 0;
        while (i < n) {
            int c = fragment.codePointAt(i);
            if (Uri.isFragmentChar(c)) {
                output = output.write(c);
            } else {
                Uri.writeEncoded(c, output);
            }
            i = fragment.offsetByCodePoints(i, 1);
        }
    }

    static void writeEncoded(int c, Output<?> output) {
        if (c == 0) {
            Uri.writePctEncoded(192, output);
            Uri.writePctEncoded(128, output);
        } else if (c >= 0 && c <= 127) {
            Uri.writePctEncoded(c, output);
        } else if (c >= 128 && c <= 2047) {
            Uri.writePctEncoded(0xC0 | c >>> 6, output);
            Uri.writePctEncoded(0x80 | c & 0x3F, output);
        } else if (c >= 2048 && c <= 65535) {
            Uri.writePctEncoded(0xE0 | c >>> 12, output);
            Uri.writePctEncoded(0x80 | c >>> 6 & 0x3F, output);
            Uri.writePctEncoded(0x80 | c & 0x3F, output);
        } else if (c >= 65536 && c <= 0x10FFFF) {
            Uri.writePctEncoded(0xF0 | c >>> 18, output);
            Uri.writePctEncoded(0x80 | c >>> 12 & 0x3F, output);
            Uri.writePctEncoded(0x80 | c >>> 6 & 0x3F, output);
            Uri.writePctEncoded(0x80 | c & 0x3F, output);
        } else {
            Uri.writePctEncoded(239, output);
            Uri.writePctEncoded(191, output);
            Uri.writePctEncoded(189, output);
        }
    }

    static void writePctEncoded(int c, Output<?> output) {
        output = output.write(37).write((int)Base16.lowercase().encodeDigit(c >>> 4 & 0xF)).write((int)Base16.lowercase().encodeDigit(c & 0xF));
    }

    @Kind
    public static Form<Uri> form() {
        if (form == null) {
            form = new UriForm(Uri.empty());
        }
        return form;
    }
}

