/*
 * Decompiled with CFR 0.152.
 */
package swim.uri;

import java.util.Collection;
import java.util.NoSuchElementException;
import swim.uri.UriPath;
import swim.util.Builder;

public final class UriPathBuilder
implements Builder<String, UriPath> {
    UriPath first = UriPath.empty();
    UriPath last = null;
    int size = 0;
    int aliased = 0;

    boolean isEmpty() {
        return this.size == 0;
    }

    public boolean add(String component) {
        if (component == null) {
            throw new NullPointerException();
        }
        if (component.equals("/")) {
            return this.addSlash();
        }
        return this.addSegment(component);
    }

    public boolean addAll(Collection<? extends String> components) {
        if (components == null) {
            throw new NullPointerException();
        }
        if (components instanceof UriPath) {
            return this.addPath((UriPath)components);
        }
        boolean modified = false;
        for (String string : components) {
            modified = this.add(string) || modified;
        }
        return modified;
    }

    public UriPath bind() {
        this.aliased = 0;
        return this.first;
    }

    public boolean addSlash() {
        UriPath tail = UriPath.slash().dealias();
        int size = this.size;
        if (size == 0) {
            this.first = tail;
        } else {
            this.dealias(size - 1).setTail(tail);
        }
        this.last = tail;
        this.size = size + 1;
        ++this.aliased;
        return true;
    }

    public boolean addSegment(String segment) {
        segment = UriPath.cacheSegment(segment);
        UriPath tail = UriPath.segment(segment, UriPath.empty());
        int size = this.size;
        if (size == 0) {
            this.first = tail;
        } else {
            this.dealias(size - 1).setTail(tail);
        }
        this.last = tail;
        this.size = size + 1;
        ++this.aliased;
        return true;
    }

    public boolean addPath(UriPath path) {
        if (!path.isEmpty()) {
            UriPath tail;
            int size = this.size;
            if (size == 0) {
                this.first = path;
            } else {
                this.dealias(size - 1).setTail(path);
            }
            ++size;
            while (!(tail = path.tail()).isEmpty()) {
                path = tail;
                ++size;
            }
            this.last = path;
            this.size = size;
            return true;
        }
        return false;
    }

    public UriPath pop() {
        int size = this.size;
        int aliased = this.aliased;
        if (size == 0) {
            throw new NoSuchElementException();
        }
        if (size == 1) {
            UriPath first = this.first;
            this.first = first.tail();
            if (first.tail().isEmpty()) {
                this.last = null;
            }
            this.size = size - 1;
            if (aliased > 0) {
                this.aliased = aliased - 1;
            }
            return first;
        }
        UriPath last = this.dealias(size - 2);
        last.setTail(UriPath.empty());
        this.last = last;
        this.size = size - 1;
        this.aliased = aliased - 1;
        return last.tail();
    }

    UriPath dealias(int n) {
        int i;
        UriPath xi = null;
        UriPath xs = this.first;
        if (this.aliased <= n) {
            for (i = 0; i < this.aliased; ++i) {
                xi = xs;
                xs = xs.tail();
            }
            while (i <= n) {
                UriPath xn = xs.dealias();
                if (i == 0) {
                    this.first = xn;
                } else {
                    xi.setTail(xn);
                }
                xi = xn;
                xs = xs.tail();
                ++i;
            }
            if (i == this.size) {
                this.last = xi;
            }
            this.aliased = i;
        } else if (n == 0) {
            xi = this.first;
        } else if (n == this.size - 1) {
            xi = this.last;
        } else {
            while (i <= n) {
                xi = xs;
                xs = xs.tail();
                ++i;
            }
        }
        return xi;
    }
}

