/*
 * Decompiled with CFR 0.152.
 */
package swim.uri;

import java.util.Collection;
import java.util.NoSuchElementException;
import swim.codec.Output;
import swim.uri.UriPath;

final class UriPathEmpty
extends UriPath {
    UriPathEmpty() {
    }

    @Override
    public boolean isDefined() {
        return false;
    }

    @Override
    public boolean isAbsolute() {
        return false;
    }

    @Override
    public boolean isRelative() {
        return true;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public String head() {
        throw new NoSuchElementException();
    }

    @Override
    public UriPath tail() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void setTail(UriPath tail) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected UriPath dealias() {
        return this;
    }

    @Override
    public UriPath appended(Collection<? extends String> components) {
        return UriPath.from(components);
    }

    @Override
    public UriPath appendedSlash() {
        return UriPath.slash();
    }

    @Override
    public UriPath appendedSegment(String segment) {
        return UriPath.segment(segment);
    }

    @Override
    public UriPath prepended(Collection<? extends String> components) {
        return UriPath.from(components);
    }

    @Override
    public UriPath prependedSlash() {
        return UriPath.slash();
    }

    @Override
    public UriPath prependedSegment(String segment) {
        return UriPath.segment(segment);
    }

    @Override
    public UriPath removeDotSegments() {
        return this;
    }

    @Override
    public UriPath merge(UriPath that) {
        if (that == null) {
            throw new NullPointerException();
        }
        return that;
    }

    @Override
    public void debug(Output<?> output) {
        output = output.write("UriPath").write(46).write("empty").write(40).write(41);
    }

    @Override
    public void display(Output<?> output) {
    }

    @Override
    public String toString() {
        return "";
    }
}

