/*
 * Decompiled with CFR 0.152.
 */
package swim.uri;

import swim.codec.Debug;
import swim.codec.Display;
import swim.codec.Output;
import swim.collections.HashTrieMap;
import swim.structure.Form;
import swim.structure.Kind;
import swim.uri.Uri;
import swim.uri.UriAuthority;
import swim.uri.UriConstantPattern;
import swim.uri.UriFragment;
import swim.uri.UriPath;
import swim.uri.UriPatternForm;
import swim.uri.UriQuery;
import swim.uri.UriScheme;
import swim.uri.UriSchemePattern;
import swim.util.Murmur3;

public abstract class UriPattern
implements Debug,
Display {
    private static int hashSeed;
    private static UriPattern empty;
    private static Form<UriPattern> form;

    UriPattern() {
    }

    public abstract Uri toUri();

    public Uri apply(String ... args) {
        return this.apply(args, 0);
    }

    Uri apply(String[] args, int index) {
        return this.apply(UriScheme.undefined(), args, index);
    }

    Uri apply(UriScheme scheme, String[] args, int index) {
        return this.apply(scheme, UriAuthority.undefined(), args, index);
    }

    Uri apply(UriScheme scheme, UriAuthority authority, String[] args, int index) {
        return this.apply(scheme, authority, UriPath.empty(), args, index);
    }

    Uri apply(UriScheme scheme, UriAuthority authority, UriPath path, String[] args, int index) {
        return this.apply(scheme, authority, path, UriQuery.undefined(), args, index);
    }

    Uri apply(UriScheme scheme, UriAuthority authority, UriPath path, UriQuery query, String[] args, int index) {
        return this.apply(scheme, authority, path, query, UriFragment.undefined(), args, index);
    }

    Uri apply(UriScheme scheme, UriAuthority authority, UriPath path, UriQuery query, UriFragment fragment, String[] args, int index) {
        return new Uri(scheme, authority, path, query, fragment);
    }

    public abstract HashTrieMap<String, String> unapply(Uri var1, HashTrieMap<String, String> var2);

    public HashTrieMap<String, String> unapply(String uri, HashTrieMap<String, String> defaults) {
        return this.unapply(Uri.parse(uri), defaults);
    }

    public HashTrieMap<String, String> unapply(Uri uri) {
        return this.unapply(uri, (HashTrieMap<String, String>)HashTrieMap.empty());
    }

    public HashTrieMap<String, String> unapply(String uri) {
        return this.unapply(Uri.parse(uri), (HashTrieMap<String, String>)HashTrieMap.empty());
    }

    public abstract boolean matches(Uri var1);

    public boolean matches(String uri) {
        return this.matches(Uri.parse(uri));
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof UriPattern) {
            UriPattern that = (UriPattern)other;
            return this.toUri().equals(that.toUri());
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(UriPattern.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)hashSeed, (int)this.toUri().hashCode()));
    }

    public void debug(Output<?> output) {
        Uri uri = this.toUri();
        output = output.write("UriPattern").write(46);
        output = uri.isDefined() ? output.write("parse").write(40).debug((Object)uri.toString()).write(41) : output.write("empty").write(40).write(41);
    }

    public void display(Output<?> output) {
        this.toUri().display(output);
    }

    public String toString() {
        return this.toUri().toString();
    }

    public static UriPattern empty() {
        if (empty == null) {
            empty = new UriConstantPattern(Uri.empty());
        }
        return empty;
    }

    public static UriPattern from(Uri pattern) {
        return UriSchemePattern.compile(pattern, pattern.scheme(), pattern.authority(), pattern.path(), pattern.query(), pattern.fragment());
    }

    public static UriPattern parse(String pattern) {
        return UriPattern.from(Uri.parse(pattern));
    }

    @Kind
    public static Form<UriPattern> form() {
        if (form == null) {
            form = new UriPatternForm(UriPattern.empty());
        }
        return form;
    }
}

