/*
 * Decompiled with CFR 0.152.
 */
package swim.mqtt;

import swim.codec.Debug;
import swim.codec.Encoder;
import swim.codec.Format;
import swim.codec.Output;
import swim.codec.OutputBuffer;
import swim.mqtt.MqttEncoder;
import swim.mqtt.MqttPacket;
import swim.util.Murmur3;

public final class MqttPingReq
extends MqttPacket<Object>
implements Debug {
    final int packetFlags;
    private static int hashSeed;
    private static MqttPingReq packet;

    MqttPingReq(int packetFlags) {
        this.packetFlags = packetFlags;
    }

    @Override
    public int packetType() {
        return 12;
    }

    @Override
    public int packetFlags() {
        return this.packetFlags;
    }

    public MqttPingReq packetFlags(int packetFlags) {
        return new MqttPingReq(packetFlags);
    }

    @Override
    int bodySize(MqttEncoder mqtt) {
        return 0;
    }

    public Encoder<?, MqttPingReq> mqttEncoder(MqttEncoder mqtt) {
        return mqtt.pingReqEncoder(this);
    }

    public Encoder<?, MqttPingReq> encodeMqtt(OutputBuffer<?> output, MqttEncoder mqtt) {
        return mqtt.encodePingReq(this, output);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof MqttPingReq) {
            MqttPingReq that = (MqttPingReq)other;
            return this.packetFlags == that.packetFlags;
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(MqttPingReq.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)hashSeed, (int)this.packetFlags));
    }

    public void debug(Output<?> output) {
        output = output.write("MqttPingReq").write(46).write("packet").write(40).write(41);
        if (this.packetFlags != 0) {
            output = output.write(46).write("packetFlags").write(40).debug((Object)this.packetFlags).write(41);
        }
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static MqttPingReq packet() {
        if (packet == null) {
            packet = new MqttPingReq(0);
        }
        return packet;
    }

    public static MqttPingReq from(int packetFlags) {
        if (packetFlags == 0) {
            return MqttPingReq.packet();
        }
        return new MqttPingReq(packetFlags);
    }
}

