/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.downlink;

import swim.runtime.downlink.DownlinkRelay;
import swim.runtime.downlink.ListDownlinkModel;
import swim.runtime.downlink.ListDownlinkView;
import swim.structure.Record;
import swim.structure.Value;
import swim.warp.EventMessage;

final class ListDownlinkRelayDrop
extends DownlinkRelay<ListDownlinkModel, ListDownlinkView<?>> {
    final EventMessage message;
    final int lower;

    ListDownlinkRelayDrop(ListDownlinkModel model, EventMessage message, int lower) {
        super(model, 4);
        this.message = message;
        this.lower = lower;
    }

    ListDownlinkRelayDrop(ListDownlinkModel model, int lower) {
        super(model, 1, 3);
        this.message = null;
        this.lower = lower;
    }

    @Override
    void beginPhase(int phase) {
        if (phase == 2 && ((ListDownlinkModel)this.model).isStateful()) {
            ((ListDownlinkModel)this.model).state.drop(this.lower);
        }
    }

    @Override
    boolean runPhase(ListDownlinkView<?> view, int phase, boolean preemptive) {
        if (phase == 0) {
            if (preemptive) {
                view.downlinkWillReceive(this.message);
            }
            return view.dispatchWillReceive(this.message.body(), preemptive);
        }
        if (phase == 1) {
            if (preemptive) {
                view.downlinkWillDrop(this.lower);
            }
            return view.dispatchWillDrop(this.lower, preemptive);
        }
        if (phase == 2) {
            if (preemptive) {
                view.downlinkDidDrop(this.lower);
            }
            return view.dispatchDidDrop(this.lower, preemptive);
        }
        if (phase == 3) {
            if (preemptive) {
                view.downlinkDidReceive(this.message);
            }
            return view.dispatchDidReceive(this.message.body(), preemptive);
        }
        throw new AssertionError();
    }

    @Override
    void done() {
        if (this.message != null) {
            ((ListDownlinkModel)this.model).cueDown();
        } else {
            ((ListDownlinkModel)this.model).pushUp((Value)Record.create((int)1).attr("drop", this.lower));
        }
    }
}

