/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.downlink;

import java.util.Map;
import swim.runtime.downlink.DownlinkRelay;
import swim.runtime.downlink.ListDownlinkModel;
import swim.runtime.downlink.ListDownlinkView;
import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Record;
import swim.structure.Value;
import swim.warp.EventMessage;

final class ListDownlinkRelayMove
extends DownlinkRelay<ListDownlinkModel, ListDownlinkView<?>> {
    final EventMessage message;
    final int fromIndex;
    final int toIndex;
    Object key;
    Form<Object> valueForm;
    Value value;
    Object object;

    ListDownlinkRelayMove(ListDownlinkModel model, EventMessage message, int fromIndex, int toIndex, Object key) {
        super(model, 4);
        this.message = message;
        this.fromIndex = fromIndex;
        this.toIndex = toIndex;
        this.key = key;
    }

    ListDownlinkRelayMove(ListDownlinkModel model, int fromIndex, int toIndex, Object key) {
        super(model, 1, 3);
        this.message = null;
        this.fromIndex = fromIndex;
        this.toIndex = toIndex;
        this.key = key;
    }

    @Override
    void beginPhase(int phase) {
        if (phase == 2) {
            ((ListDownlinkModel)this.model).state.move(this.fromIndex, this.toIndex, this.key);
            if (this.value == null) {
                this.value = Value.absent();
            }
            if (this.valueForm != null) {
                this.object = this.valueForm.cast((Item)this.value);
                if (this.object == null) {
                    this.object = this.valueForm.unit();
                }
            }
        }
    }

    @Override
    boolean runPhase(ListDownlinkView<?> view, int phase, boolean preemptive) {
        if (phase == 0) {
            if (preemptive) {
                view.downlinkWillReceive(this.message);
            }
            return view.dispatchWillReceive(this.message.body(), preemptive);
        }
        if (phase == 1) {
            view.downlinkWillMoveValue(this.fromIndex, this.toIndex, this.value);
            Form valueForm = view.valueForm;
            this.valueForm = valueForm;
            Map.Entry entry = ((ListDownlinkModel)this.model).state.getEntry(this.fromIndex, this.key);
            this.value = (Value)entry.getValue();
            this.key = entry.getKey();
            this.object = valueForm.cast((Item)this.value);
            if (this.object == null) {
                this.object = valueForm.unit();
            }
            if (preemptive) {
                view.downlinkWillMove(this.fromIndex, this.toIndex, this.value);
            }
            return view.dispatchWillMove(this.fromIndex, this.toIndex, this.value, preemptive);
        }
        if (phase == 2) {
            view.downlinkDidMoveValue(this.fromIndex, this.toIndex, this.value);
            Form valueForm = view.valueForm;
            if (this.valueForm != valueForm && valueForm != null) {
                this.valueForm = valueForm;
                this.object = valueForm.cast((Item)this.value);
                if (this.object == null) {
                    this.object = valueForm.unit();
                }
            }
            if (preemptive) {
                view.downlinkDidMove(this.fromIndex, this.toIndex, this.object);
            }
            return view.dispatchDidMove(this.fromIndex, this.toIndex, this.object, preemptive);
        }
        if (phase == 3) {
            if (preemptive) {
                view.downlinkDidReceive(this.message);
            }
            return view.dispatchDidReceive(this.message.body(), preemptive);
        }
        throw new AssertionError();
    }

    @Override
    void done() {
        if (this.message != null) {
            ((ListDownlinkModel)this.model).cueDown();
        } else {
            Record header = Record.create((int)3).slot("key", Value.fromObject((Object)this.key)).slot("from", this.fromIndex).slot("to", this.toIndex);
            ((ListDownlinkModel)this.model).pushUp((Value)Record.create((int)1).attr("move", (Value)header));
        }
    }
}

