/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.lane;

import swim.concurrent.Conts;
import swim.concurrent.Stage;
import swim.runtime.lane.LaneModel;
import swim.runtime.lane.LaneView;

abstract class LaneRelay<Model extends LaneModel<View, ?>, View extends LaneView>
implements Runnable {
    final Model model;
    final Object views;
    int viewIndex;
    final int viewCount;
    int phase;
    final int phaseCount;
    boolean preemptive;
    Stage stage;

    LaneRelay(Model model, int minPhase, int phaseCount) {
        this.model = model;
        this.views = ((LaneModel)model).views;
        this.viewCount = this.views instanceof LaneView ? 1 : (this.views instanceof LaneView[] ? ((LaneView[])this.views).length : 0);
        this.phase = minPhase;
        this.phaseCount = phaseCount;
        this.preemptive = true;
        this.beginPhase(this.phase);
    }

    LaneRelay(Model model, int phaseCount) {
        this(model, 0, phaseCount);
    }

    LaneRelay(Model model) {
        this(model, 0, 1);
    }

    boolean isDone() {
        return this.phase > this.phaseCount;
    }

    void beginPhase(int phase) {
    }

    boolean runPhase(View view, int phase, boolean preemptive) {
        return true;
    }

    void endPhase(int phase) {
    }

    void done() {
    }

    void pass(View view) {
        block6: {
            while (true) {
                if (this.viewIndex < this.viewCount) {
                    try {
                        if (!this.runPhase(view, this.phase, this.preemptive) && this.preemptive) {
                            this.preemptive = false;
                            if (this.stage != null) continue;
                            this.stage = ((LaneModel)this.model).stage();
                            this.stage.execute((Runnable)this);
                            return;
                        }
                    }
                    catch (Throwable error) {
                        if (Conts.isNonFatal((Throwable)error)) {
                            ((LaneView)view).laneDidFail(error);
                        }
                        throw error;
                    }
                    ++this.viewIndex;
                    continue;
                }
                if (this.phase >= this.phaseCount) break block6;
                this.endPhase(this.phase);
                this.viewIndex = 0;
                ++this.phase;
                this.preemptive = true;
                if (this.phase >= this.phaseCount) break;
                this.beginPhase(this.phase);
            }
            this.endPhase(this.phase);
            ++this.phase;
            this.done();
            return;
        }
    }

    void pass(LaneView[] views) {
        block6: {
            while (true) {
                if (this.viewIndex < this.viewCount) {
                    LaneView view = views[this.viewIndex];
                    try {
                        if (!this.runPhase(view, this.phase, this.preemptive) && this.preemptive) {
                            this.preemptive = false;
                            if (this.stage != null) continue;
                            this.stage = ((LaneModel)this.model).stage();
                            this.stage.execute((Runnable)this);
                            return;
                        }
                    }
                    catch (Throwable error) {
                        if (Conts.isNonFatal((Throwable)error)) {
                            view.laneDidFail(error);
                        }
                        throw error;
                    }
                    ++this.viewIndex;
                    continue;
                }
                if (this.phase >= this.phaseCount) break block6;
                this.endPhase(this.phase);
                this.viewIndex = 0;
                ++this.phase;
                this.preemptive = true;
                if (this.phase >= this.phaseCount) break;
                this.beginPhase(this.phase);
            }
            this.endPhase(this.phase);
            ++this.phase;
            this.done();
            return;
        }
    }

    @Override
    public void run() {
        try {
            if (this.viewCount == 1) {
                this.pass((LaneView)this.views);
            } else if (this.viewCount > 1) {
                this.pass((LaneView[])this.views);
            }
        }
        catch (Throwable error) {
            if (Conts.isNonFatal((Throwable)error)) {
                ((LaneModel)this.model).didFail(error);
            }
            throw error;
        }
    }
}

