/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.lane;

import swim.runtime.lane.LaneModel;
import swim.runtime.lane.LaneRelay;
import swim.runtime.lane.LaneView;
import swim.warp.CommandMessage;

final class LaneRelayOnCommand<View extends LaneView>
extends LaneRelay<LaneModel<View, ?>, View> {
    final CommandMessage message;

    LaneRelayOnCommand(LaneModel<View, ?> model, CommandMessage message) {
        super(model, 2);
        this.message = message;
    }

    @Override
    boolean runPhase(View view, int phase, boolean preemptive) {
        if (phase == 0) {
            if (preemptive) {
                ((LaneView)view).laneWillCommand(this.message);
            }
            return ((LaneView)view).dispatchWillCommand(this.message.body(), preemptive);
        }
        if (phase == 1) {
            if (preemptive) {
                ((LaneView)view).laneDidCommand(this.message);
            }
            return ((LaneView)view).dispatchDidCommand(this.message.body(), preemptive);
        }
        throw new AssertionError();
    }
}

