/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.lane;

import java.util.Iterator;
import java.util.Map;
import swim.api.data.MapData;
import swim.collections.FingerTrieSeq;
import swim.runtime.LaneContext;
import swim.runtime.LinkBinding;
import swim.runtime.lane.LaneModel;
import swim.runtime.lane.LaneView;
import swim.runtime.lane.MapLaneRelayClear;
import swim.runtime.lane.MapLaneRelayDrop;
import swim.runtime.lane.MapLaneRelayRemove;
import swim.runtime.lane.MapLaneRelayTake;
import swim.runtime.lane.MapLaneRelayUpdate;
import swim.runtime.lane.MapLaneUplink;
import swim.runtime.lane.MapLaneView;
import swim.runtime.lane.ValueLaneView;
import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Value;
import swim.warp.CommandMessage;

public class MapLaneModel
extends LaneModel<MapLaneView<?, ?>, MapLaneUplink> {
    protected int flags;
    protected MapData<Value, Value> data;
    static final int RESIDENT = 1;
    static final int TRANSIENT = 2;
    static final int SIGNED = 4;

    MapLaneModel(int flags) {
        this.flags = flags;
    }

    public MapLaneModel() {
        this(0);
    }

    @Override
    protected MapLaneUplink createUplink(LinkBinding link) {
        return new MapLaneUplink(this, link);
    }

    @Override
    public void setLaneContext(LaneContext laneContext) {
        super.setLaneContext(laneContext);
        this.openStore();
    }

    protected void openStore() {
        this.data = this.laneContext.data().mapData(this.laneUri().toString()).isResident(this.isResident()).isTransient(this.isTransient());
    }

    @Override
    protected void didOpenLaneView(MapLaneView<?, ?> view) {
        view.setLaneBinding(this);
    }

    @Override
    public void onCommand(CommandMessage message) {
        Value payload = message.body();
        String tag = payload.tag();
        if ("update".equals(tag)) {
            Value header = payload.header("update");
            Value key = header.get("key");
            Value value = payload.body();
            new MapLaneRelayUpdate(this, null, message, key, value).run();
        } else if ("remove".equals(tag)) {
            Value header = payload.header("remove");
            Value key = header.get("key");
            new MapLaneRelayRemove(this, null, message, key).run();
        } else if ("drop".equals(tag)) {
            Value header = payload.header("drop");
            int lower = header.intValue(0);
            new MapLaneRelayDrop(this, null, message, lower).run();
        } else if ("take".equals(tag)) {
            Value header = payload.header("take");
            int upper = header.intValue(0);
            new MapLaneRelayTake(this, null, message, upper).run();
        } else if ("clear".equals(tag)) {
            new MapLaneRelayClear(this, null, message).run();
        }
    }

    protected void cueDownKey(Value key) {
        FingerTrieSeq uplinks;
        do {
            uplinks = this.uplinks;
            int n = uplinks.size();
            for (int i = 0; i < n; ++i) {
                ((MapLaneUplink)uplinks.get(i)).cueDownKey(key);
            }
        } while (uplinks != this.uplinks);
    }

    public final boolean isResident() {
        return (this.flags & 1) != 0;
    }

    public MapLaneModel isResident(boolean isResident) {
        if (this.data != null) {
            this.data.isResident(isResident);
        }
        this.flags = isResident ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
        Object views = this.views;
        if (views instanceof MapLaneView) {
            ((MapLaneView)views).didSetResident(isResident);
        } else if (views instanceof LaneView[]) {
            LaneView[] viewArray = (LaneView[])views;
            int n = viewArray.length;
            for (int i = 0; i < n; ++i) {
                ((MapLaneView)viewArray[i]).didSetResident(isResident);
            }
        }
        return this;
    }

    public final boolean isTransient() {
        return (this.flags & 2) != 0;
    }

    public MapLaneModel isTransient(boolean isTransient) {
        if (this.data != null) {
            this.data.isTransient(isTransient);
        }
        this.flags = isTransient ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
        Object views = this.views;
        if (views instanceof ValueLaneView) {
            ((ValueLaneView)views).didSetTransient(isTransient);
        } else if (views instanceof LaneView[]) {
            LaneView[] viewArray = (LaneView[])views;
            int n = viewArray.length;
            for (int i = 0; i < n; ++i) {
                ((ValueLaneView)viewArray[i]).didSetTransient(isTransient);
            }
        }
        return this;
    }

    public final boolean isSigned() {
        return (this.flags & 4) != 0;
    }

    public MapLaneModel isSigned(boolean isSigned) {
        this.flags = isSigned ? (this.flags |= 4) : (this.flags &= 0xFFFFFFFB);
        Object views = this.views;
        if (views instanceof MapLaneView) {
            ((MapLaneView)views).didSetSigned(isSigned);
        } else if (views instanceof LaneView[]) {
            LaneView[] viewArray = (LaneView[])views;
            int n = viewArray.length;
            for (int i = 0; i < n; ++i) {
                ((MapLaneView)viewArray[i]).didSetSigned(isSigned);
            }
        }
        return this;
    }

    public Value get(Value key) {
        if (key != null) {
            Value value = (Value)this.data.get((Object)key);
            if (this.isSigned()) {
                // empty if block
            }
            return value;
        }
        return Value.absent();
    }

    public <K, V> V put(MapLaneView<K, V> view, K keyObject, V newObject) {
        Form keyForm = view.keyForm;
        Form valueForm = view.valueForm;
        Value key = keyForm.mold(keyObject).toValue();
        Value newValue = valueForm.mold(newObject).toValue();
        MapLaneRelayUpdate relay = new MapLaneRelayUpdate(this, null, key, newValue);
        relay.keyForm = keyForm;
        relay.valueForm = valueForm;
        relay.keyObject = keyObject;
        relay.oldObject = newObject;
        relay.newObject = newObject;
        relay.stage = this.stage();
        relay.run();
        if (relay.valueForm != valueForm && valueForm != null) {
            relay.oldObject = valueForm.cast((Item)relay.oldValue);
            if (relay.oldObject == null) {
                relay.oldObject = valueForm.unit();
            }
        }
        return (V)relay.oldObject;
    }

    public <K, V> V remove(MapLaneView<K, V> view, K keyObject) {
        Form keyForm = view.keyForm;
        Form valueForm = view.valueForm;
        Value key = keyForm.mold(keyObject).toValue();
        MapLaneRelayRemove relay = new MapLaneRelayRemove(this, null, key);
        relay.keyForm = keyForm;
        relay.valueForm = valueForm;
        relay.keyObject = keyObject;
        relay.stage = this.stage();
        relay.run();
        if (relay.valueForm == valueForm || valueForm == null) {
            return (V)relay.oldObject;
        }
        return (V)valueForm.unit();
    }

    public void drop(MapLaneView<?, ?> view, int lower) {
        MapLaneRelayDrop relay = new MapLaneRelayDrop(this, null, lower);
        relay.stage = this.stage();
        relay.run();
    }

    public void take(MapLaneView<?, ?> view, int upper) {
        MapLaneRelayTake relay = new MapLaneRelayTake(this, null, upper);
        relay.stage = this.stage();
        relay.run();
    }

    public void clear(MapLaneView<?, ?> view) {
        MapLaneRelayClear relay = new MapLaneRelayClear(this, null);
        relay.stage = this.stage();
        relay.run();
    }

    public Iterator<Map.Entry<Value, Value>> iterator() {
        return this.data.iterator();
    }
}

