/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.router;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import swim.api.data.DataFactory;
import swim.api.downlink.Downlink;
import swim.api.policy.Policy;
import swim.collections.HashTrieMap;
import swim.concurrent.Schedule;
import swim.concurrent.Stage;
import swim.math.Z2Form;
import swim.runtime.AbstractTierBinding;
import swim.runtime.HostBinding;
import swim.runtime.HostContext;
import swim.runtime.HttpBinding;
import swim.runtime.LinkBinding;
import swim.runtime.PartBinding;
import swim.runtime.PartContext;
import swim.runtime.PartPredicate;
import swim.runtime.PushRequest;
import swim.runtime.TierBinding;
import swim.runtime.TierContext;
import swim.runtime.router.PartTableHost;
import swim.runtime.router.PartTableUplink;
import swim.runtime.uplink.ErrorUplinkModem;
import swim.runtime.uplink.HttpErrorUplinkModem;
import swim.store.DataBinding;
import swim.store.ListDataBinding;
import swim.store.MapDataBinding;
import swim.store.SpatialDataBinding;
import swim.store.ValueDataBinding;
import swim.structure.Record;
import swim.structure.Value;
import swim.uri.Uri;

public class PartTable
extends AbstractTierBinding
implements PartBinding {
    final PartPredicate predicate;
    protected PartContext partContext;
    volatile HashTrieMap<Uri, HostBinding> hosts = HashTrieMap.empty();
    volatile HashTrieMap<Value, PartTableUplink> uplinks = HashTrieMap.empty();
    volatile HostBinding master;
    static final AtomicReferenceFieldUpdater<PartTable, HashTrieMap<Uri, HostBinding>> HOSTS = AtomicReferenceFieldUpdater.newUpdater(PartTable.class, HashTrieMap.class, "hosts");
    static final AtomicReferenceFieldUpdater<PartTable, HashTrieMap<Value, PartTableUplink>> UPLINKS = AtomicReferenceFieldUpdater.newUpdater(PartTable.class, HashTrieMap.class, "uplinks");

    public PartTable(PartPredicate predicate) {
        this.predicate = predicate;
    }

    public PartTable() {
        this(PartPredicate.any());
    }

    @Override
    public final TierContext tierContext() {
        return this.partContext;
    }

    @Override
    public final PartContext partContext() {
        return this.partContext;
    }

    @Override
    public void setPartContext(PartContext partContext) {
        this.partContext = partContext;
    }

    @Override
    public <T> T unwrapPart(Class<T> partClass) {
        if (partClass.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        return null;
    }

    protected HostContext createHostContext(HostBinding host, Uri hostUri) {
        return new PartTableHost(this, host, hostUri);
    }

    @Override
    public final Uri meshUri() {
        return this.partContext.meshUri();
    }

    @Override
    public final Value partKey() {
        return this.partContext.partKey();
    }

    @Override
    public Policy policy() {
        return this.partContext.policy();
    }

    @Override
    public Schedule schedule() {
        return this.partContext.schedule();
    }

    @Override
    public Stage stage() {
        return this.partContext.stage();
    }

    @Override
    public DataFactory data() {
        return this.partContext.data();
    }

    @Override
    public PartPredicate predicate() {
        return this.predicate;
    }

    @Override
    public HostBinding getMaster() {
        return this.master;
    }

    @Override
    public void setMaster(HostBinding master) {
        this.master = master;
    }

    @Override
    public HashTrieMap<Uri, HostBinding> getHosts() {
        return this.hosts;
    }

    @Override
    public HostBinding getHost(Uri hostUri) {
        return (HostBinding)this.hosts.get((Object)hostUri);
    }

    @Override
    public HostBinding openHost(Uri hostUri) {
        HashTrieMap newHosts;
        HashTrieMap oldHosts;
        TierBinding hostBinding = null;
        do {
            HostBinding host;
            if ((host = (HostBinding)(oldHosts = this.hosts).get((Object)hostUri)) != null) {
                if (hostBinding != null) {
                    hostBinding.close();
                }
                hostBinding = host;
                newHosts = oldHosts;
                break;
            }
            if (hostBinding == null) {
                hostBinding = this.partContext.createHost(hostUri);
                if (hostBinding != null) {
                    hostBinding = this.partContext.injectHost(hostUri, (HostBinding)hostBinding);
                    HostContext hostContext = this.createHostContext((HostBinding)hostBinding, hostUri);
                    hostBinding.setHostContext(hostContext);
                    newHosts = oldHosts.updated((Object)hostUri, (Object)hostBinding);
                    continue;
                }
                newHosts = oldHosts;
                break;
            }
            newHosts = oldHosts.updated((Object)hostUri, (Object)hostBinding);
        } while (oldHosts != newHosts && !HOSTS.compareAndSet(this, (HashTrieMap<Uri, HostBinding>)oldHosts, (HashTrieMap<Uri, HostBinding>)newHosts));
        if (oldHosts != newHosts) {
            this.activate(hostBinding);
        }
        return hostBinding;
    }

    @Override
    public HostBinding openHost(Uri hostUri, HostBinding host) {
        HashTrieMap newHosts;
        HashTrieMap oldHosts;
        HostBinding hostBinding = null;
        do {
            if ((oldHosts = this.hosts).containsKey((Object)hostUri) && host.hostContext() != null) {
                hostBinding = null;
                newHosts = oldHosts;
                break;
            }
            if (hostBinding != null) continue;
            hostBinding = this.partContext.injectHost(hostUri, host);
            HostContext hostContext = this.createHostContext(hostBinding, hostUri);
            hostBinding.setHostContext(hostContext);
        } while (oldHosts != (newHosts = oldHosts.updated((Object)hostUri, hostBinding)) && !HOSTS.compareAndSet(this, (HashTrieMap<Uri, HostBinding>)oldHosts, (HashTrieMap<Uri, HostBinding>)newHosts));
        if (hostBinding != null) {
            this.activate(hostBinding);
        }
        return hostBinding;
    }

    public void closeHost(Uri hostUri) {
        HashTrieMap newHosts;
        HashTrieMap oldHosts;
        HostBinding hostBinding = null;
        do {
            HostBinding host;
            if ((host = (HostBinding)(oldHosts = this.hosts).get((Object)hostUri)) == null) {
                hostBinding = null;
                newHosts = oldHosts;
                break;
            }
            hostBinding = host;
            newHosts = oldHosts.removed((Object)hostUri);
        } while (oldHosts != newHosts && !HOSTS.compareAndSet(this, (HashTrieMap<Uri, HostBinding>)oldHosts, (HashTrieMap<Uri, HostBinding>)newHosts));
        if (hostBinding != null) {
            if (this.master == hostBinding) {
                this.master = null;
            }
            hostBinding.didClose();
        }
    }

    public void hostDidConnect(Uri hostUri) {
        this.partContext.hostDidConnect(hostUri);
    }

    public void hostDidDisconnect(Uri hostUri) {
        this.partContext.hostDidDisconnect(hostUri);
    }

    @Override
    public void reopenUplinks() {
        for (PartTableUplink uplink : this.uplinks.values()) {
            uplink.reopen();
        }
    }

    public Iterator<DataBinding> dataBindings() {
        return Collections.emptyIterator();
    }

    public void closeData(Value name) {
    }

    public ListDataBinding openListData(Value name) {
        return this.partContext.openListData(name);
    }

    public ListDataBinding injectListData(ListDataBinding dataBinding) {
        return this.partContext.injectListData(dataBinding);
    }

    public MapDataBinding openMapData(Value name) {
        return this.partContext.openMapData(name);
    }

    public MapDataBinding injectMapData(MapDataBinding dataBinding) {
        return this.partContext.injectMapData(dataBinding);
    }

    public <S> SpatialDataBinding<S> openSpatialData(Value name, Z2Form<S> shapeForm) {
        return this.partContext.openSpatialData(name, shapeForm);
    }

    public <S> SpatialDataBinding<S> injectSpatialData(SpatialDataBinding<S> dataBinding) {
        return this.partContext.injectSpatialData(dataBinding);
    }

    public ValueDataBinding openValueData(Value name) {
        return this.partContext.openValueData(name);
    }

    public ValueDataBinding injectValueData(ValueDataBinding dataBinding) {
        return this.partContext.injectValueData(dataBinding);
    }

    @Override
    public LinkBinding bindDownlink(Downlink downlink) {
        return this.partContext.bindDownlink(downlink);
    }

    @Override
    public void openDownlink(LinkBinding link) {
        this.partContext.openDownlink(link);
    }

    @Override
    public void closeDownlink(LinkBinding link) {
    }

    @Override
    public void openUplink(LinkBinding link) {
        HostBinding hostBinding = null;
        if (!link.hostUri().isDefined()) {
            hostBinding = this.master;
        }
        if (hostBinding == null) {
            hostBinding = this.openHost(link.hostUri());
        }
        if (hostBinding != null) {
            hostBinding.openUplink(new PartTableUplink(this, link));
        } else {
            ErrorUplinkModem linkContext = new ErrorUplinkModem(link, (Value)Record.of().attr("badHost"));
            link.setLinkContext(linkContext);
            linkContext.cueDown();
        }
    }

    void didOpenUplink(PartTableUplink uplink) {
        HashTrieMap newUplinks;
        HashTrieMap<Value, PartTableUplink> oldUplinks;
        while ((oldUplinks = this.uplinks) != (newUplinks = oldUplinks.updated((Object)uplink.linkKey(), (Object)uplink)) && !UPLINKS.compareAndSet(this, oldUplinks, (HashTrieMap<Value, PartTableUplink>)newUplinks)) {
        }
    }

    void didCloseUplink(PartTableUplink uplink) {
        HashTrieMap newUplinks;
        HashTrieMap<Value, PartTableUplink> oldUplinks;
        while ((oldUplinks = this.uplinks) != (newUplinks = oldUplinks.removed((Object)uplink.linkKey())) && !UPLINKS.compareAndSet(this, oldUplinks, (HashTrieMap<Value, PartTableUplink>)newUplinks)) {
        }
    }

    @Override
    public void httpDownlink(HttpBinding http) {
    }

    @Override
    public void httpUplink(HttpBinding http) {
        HostBinding hostBinding = null;
        if (!http.hostUri().isDefined()) {
            hostBinding = this.master;
        }
        if (hostBinding == null) {
            hostBinding = this.openHost(http.hostUri());
        }
        if (hostBinding != null) {
            hostBinding.httpUplink(http);
        } else {
            HttpErrorUplinkModem httpContext = new HttpErrorUplinkModem(http);
            http.setHttpContext(httpContext);
        }
    }

    @Override
    public void pushDown(PushRequest pushRequest) {
        this.partContext.pushDown(pushRequest);
    }

    @Override
    public void pushUp(PushRequest pushRequest) {
        HostBinding hostBinding = null;
        if (!pushRequest.hostUri().isDefined()) {
            hostBinding = this.master;
        }
        if (hostBinding == null) {
            hostBinding = this.openHost(pushRequest.hostUri());
        }
        if (hostBinding != null) {
            hostBinding.pushUp(pushRequest);
        } else {
            pushRequest.didDecline();
        }
    }

    public void trace(Object message) {
        this.partContext.trace(message);
    }

    public void debug(Object message) {
        this.partContext.debug(message);
    }

    public void info(Object message) {
        this.partContext.info(message);
    }

    public void warn(Object message) {
        this.partContext.warn(message);
    }

    public void error(Object message) {
        this.partContext.error(message);
    }

    @Override
    protected void willOpen() {
        super.willOpen();
        Iterator hostsIterator = this.hosts.valueIterator();
        while (hostsIterator.hasNext()) {
            ((HostBinding)hostsIterator.next()).open();
        }
    }

    @Override
    protected void willLoad() {
        super.willLoad();
        Iterator hostsIterator = this.hosts.valueIterator();
        while (hostsIterator.hasNext()) {
            ((HostBinding)hostsIterator.next()).load();
        }
    }

    @Override
    protected void willStart() {
        super.willStart();
        Iterator hostsIterator = this.hosts.valueIterator();
        while (hostsIterator.hasNext()) {
            ((HostBinding)hostsIterator.next()).start();
        }
    }

    @Override
    protected void willStop() {
        super.willStop();
        Iterator hostsIterator = this.hosts.valueIterator();
        while (hostsIterator.hasNext()) {
            ((HostBinding)hostsIterator.next()).stop();
        }
    }

    @Override
    protected void willUnload() {
        super.willUnload();
        Iterator hostsIterator = this.hosts.valueIterator();
        while (hostsIterator.hasNext()) {
            ((HostBinding)hostsIterator.next()).unload();
        }
    }

    @Override
    protected void willClose() {
        super.willClose();
        Iterator hostsIterator = this.hosts.valueIterator();
        while (hostsIterator.hasNext()) {
            ((HostBinding)hostsIterator.next()).close();
        }
    }

    @Override
    public void didClose() {
    }

    @Override
    public void didFail(Throwable error) {
        error.printStackTrace();
    }
}

