/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.router;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import swim.api.data.DataFactory;
import swim.api.downlink.Downlink;
import swim.api.policy.Policy;
import swim.collections.HashTrieMap;
import swim.concurrent.Schedule;
import swim.concurrent.Stage;
import swim.math.Z2Form;
import swim.runtime.AbstractTierBinding;
import swim.runtime.HttpBinding;
import swim.runtime.LinkBinding;
import swim.runtime.MeshBinding;
import swim.runtime.MeshContext;
import swim.runtime.PushRequest;
import swim.runtime.RootBinding;
import swim.runtime.RootContext;
import swim.runtime.TierBinding;
import swim.runtime.TierContext;
import swim.runtime.downlink.DownlinkModel;
import swim.runtime.downlink.DownlinkView;
import swim.runtime.router.RootTableMesh;
import swim.runtime.uplink.ErrorUplinkModem;
import swim.runtime.uplink.HttpErrorUplinkModem;
import swim.store.DataBinding;
import swim.store.ListDataBinding;
import swim.store.MapDataBinding;
import swim.store.SpatialDataBinding;
import swim.store.ValueDataBinding;
import swim.structure.Record;
import swim.structure.Value;
import swim.uri.Uri;

public class RootTable
extends AbstractTierBinding
implements RootBinding {
    protected RootContext rootContext;
    volatile HashTrieMap<Uri, MeshBinding> meshes = HashTrieMap.empty();
    volatile MeshBinding network;
    static final AtomicReferenceFieldUpdater<RootTable, HashTrieMap<Uri, MeshBinding>> MESHES = AtomicReferenceFieldUpdater.newUpdater(RootTable.class, HashTrieMap.class, "meshes");

    @Override
    public final TierContext tierContext() {
        return this.rootContext;
    }

    @Override
    public final RootContext rootContext() {
        return this.rootContext;
    }

    @Override
    public void setRootContext(RootContext rootContext) {
        this.rootContext = rootContext;
    }

    @Override
    public <T> T unwrapRoot(Class<T> rootClass) {
        if (rootClass.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        return null;
    }

    protected MeshContext createMeshContext(MeshBinding mesh, Uri meshUri) {
        return new RootTableMesh(this, mesh, meshUri);
    }

    @Override
    public final Uri meshUri() {
        return Uri.empty();
    }

    @Override
    public Policy policy() {
        return this.rootContext.policy();
    }

    @Override
    public Schedule schedule() {
        return this.rootContext.schedule();
    }

    @Override
    public Stage stage() {
        return this.rootContext.stage();
    }

    @Override
    public DataFactory data() {
        return this.rootContext.data();
    }

    @Override
    public MeshBinding getNetwork() {
        return this.network;
    }

    @Override
    public void setNetwork(MeshBinding network) {
        this.network = network;
    }

    @Override
    public HashTrieMap<Uri, MeshBinding> getMeshes() {
        return this.meshes;
    }

    @Override
    public MeshBinding getMesh(Uri meshUri) {
        return (MeshBinding)this.meshes.get((Object)meshUri);
    }

    @Override
    public MeshBinding openMesh(Uri meshUri) {
        HashTrieMap newMeshes;
        HashTrieMap oldMeshes;
        TierBinding meshBinding = null;
        do {
            MeshBinding mesh;
            if ((mesh = (MeshBinding)(oldMeshes = this.meshes).get((Object)meshUri)) != null) {
                if (meshBinding != null) {
                    meshBinding.close();
                }
                meshBinding = mesh;
                newMeshes = oldMeshes;
                break;
            }
            if (meshBinding == null) {
                meshBinding = this.rootContext.createMesh(meshUri);
                if (meshBinding != null) {
                    meshBinding = this.rootContext.injectMesh(meshUri, (MeshBinding)meshBinding);
                    MeshContext meshContext = this.createMeshContext((MeshBinding)meshBinding, meshUri);
                    meshBinding.setMeshContext(meshContext);
                    newMeshes = oldMeshes.updated((Object)meshUri, (Object)meshBinding);
                    continue;
                }
                newMeshes = oldMeshes;
                break;
            }
            newMeshes = oldMeshes.updated((Object)meshUri, (Object)meshBinding);
        } while (oldMeshes != newMeshes && !MESHES.compareAndSet(this, (HashTrieMap<Uri, MeshBinding>)oldMeshes, (HashTrieMap<Uri, MeshBinding>)newMeshes));
        if (oldMeshes != newMeshes) {
            this.activate(meshBinding);
        }
        return meshBinding;
    }

    @Override
    public MeshBinding openMesh(Uri meshUri, MeshBinding mesh) {
        HashTrieMap newMeshes;
        HashTrieMap oldMeshes;
        MeshBinding meshBinding = null;
        do {
            if ((oldMeshes = this.meshes).containsKey((Object)meshUri)) {
                meshBinding = null;
                newMeshes = oldMeshes;
                break;
            }
            if (meshBinding != null) continue;
            meshBinding = this.rootContext.injectMesh(meshUri, mesh);
            MeshContext meshContext = this.createMeshContext(meshBinding, meshUri);
            meshBinding.setMeshContext(meshContext);
        } while (oldMeshes != (newMeshes = oldMeshes.updated((Object)meshUri, meshBinding)) && !MESHES.compareAndSet(this, (HashTrieMap<Uri, MeshBinding>)oldMeshes, (HashTrieMap<Uri, MeshBinding>)newMeshes));
        if (meshBinding != null) {
            this.activate(meshBinding);
        }
        return meshBinding;
    }

    public void closeMesh(Uri meshUri) {
        HashTrieMap newMeshes;
        HashTrieMap oldMeshes;
        MeshBinding meshBinding = null;
        do {
            MeshBinding mesh;
            if ((mesh = (MeshBinding)(oldMeshes = this.meshes).get((Object)meshUri)) == null) {
                meshBinding = null;
                newMeshes = oldMeshes;
                break;
            }
            meshBinding = mesh;
            newMeshes = oldMeshes.removed((Object)meshUri);
        } while (oldMeshes != newMeshes && !MESHES.compareAndSet(this, (HashTrieMap<Uri, MeshBinding>)oldMeshes, (HashTrieMap<Uri, MeshBinding>)newMeshes));
        if (meshBinding != null) {
            if (this.network == meshBinding) {
                this.network = null;
            }
            meshBinding.didClose();
        }
    }

    public Iterator<DataBinding> dataBindings() {
        return Collections.emptyIterator();
    }

    public void closeData(Value name) {
    }

    public ListDataBinding openListData(Value name) {
        return this.rootContext.openListData(name);
    }

    public ListDataBinding injectListData(ListDataBinding dataBinding) {
        return this.rootContext.injectListData(dataBinding);
    }

    public MapDataBinding openMapData(Value name) {
        return this.rootContext.openMapData(name);
    }

    public MapDataBinding injectMapData(MapDataBinding dataBinding) {
        return this.rootContext.injectMapData(dataBinding);
    }

    public <S> SpatialDataBinding<S> openSpatialData(Value name, Z2Form<S> shapeForm) {
        return this.rootContext.openSpatialData(name, shapeForm);
    }

    public <S> SpatialDataBinding<S> injectSpatialData(SpatialDataBinding<S> dataBinding) {
        return this.rootContext.injectSpatialData(dataBinding);
    }

    public ValueDataBinding openValueData(Value name) {
        return this.rootContext.openValueData(name);
    }

    public ValueDataBinding injectValueData(ValueDataBinding dataBinding) {
        return this.rootContext.injectValueData(dataBinding);
    }

    @Override
    public LinkBinding bindDownlink(Downlink downlink) {
        DownlinkModel<?> link = ((DownlinkView)downlink).createDownlinkModel();
        this.openUplink(link);
        return link;
    }

    @Override
    public void openDownlink(LinkBinding link) {
        this.openUplink(link);
    }

    @Override
    public void closeDownlink(LinkBinding link) {
    }

    @Override
    public void httpDownlink(HttpBinding http) {
    }

    @Override
    public void openUplink(LinkBinding link) {
        MeshBinding meshBinding = this.openMesh(link.meshUri());
        if (meshBinding != null) {
            meshBinding.openUplink(link);
        } else {
            ErrorUplinkModem linkContext = new ErrorUplinkModem(link, (Value)Record.of().attr("noMesh"));
            link.setLinkContext(linkContext);
            linkContext.cueDown();
        }
    }

    @Override
    public void httpUplink(HttpBinding http) {
        MeshBinding meshBinding = this.openMesh(http.meshUri());
        if (meshBinding != null) {
            meshBinding.httpUplink(http);
        } else {
            HttpErrorUplinkModem httpContext = new HttpErrorUplinkModem(http);
            http.setHttpContext(httpContext);
        }
    }

    @Override
    public void pushDown(PushRequest pushRequest) {
        this.pushUp(pushRequest);
    }

    @Override
    public void pushUp(PushRequest pushRequest) {
        MeshBinding meshBinding = this.openMesh(pushRequest.meshUri());
        if (meshBinding != null) {
            meshBinding.pushUp(pushRequest);
        } else {
            pushRequest.didDecline();
        }
    }

    public void trace(Object message) {
        this.rootContext.trace(message);
    }

    public void debug(Object message) {
        this.rootContext.debug(message);
    }

    public void info(Object message) {
        this.rootContext.info(message);
    }

    public void warn(Object message) {
        this.rootContext.warn(message);
    }

    public void error(Object message) {
        this.rootContext.error(message);
    }

    @Override
    protected void willOpen() {
        super.willOpen();
        Iterator meshesIterator = this.meshes.valueIterator();
        while (meshesIterator.hasNext()) {
            ((MeshBinding)meshesIterator.next()).open();
        }
    }

    @Override
    protected void willLoad() {
        super.willLoad();
        Iterator meshesIterator = this.meshes.valueIterator();
        while (meshesIterator.hasNext()) {
            ((MeshBinding)meshesIterator.next()).load();
        }
    }

    @Override
    protected void willStart() {
        super.willStart();
        Iterator meshesIterator = this.meshes.valueIterator();
        while (meshesIterator.hasNext()) {
            ((MeshBinding)meshesIterator.next()).start();
        }
    }

    @Override
    protected void willStop() {
        super.willStop();
        Iterator meshesIterator = this.meshes.valueIterator();
        while (meshesIterator.hasNext()) {
            ((MeshBinding)meshesIterator.next()).stop();
        }
    }

    @Override
    protected void willUnload() {
        super.willUnload();
        Iterator meshesIterator = this.meshes.valueIterator();
        while (meshesIterator.hasNext()) {
            ((MeshBinding)meshesIterator.next()).unload();
        }
    }

    @Override
    protected void willClose() {
        super.willClose();
        Iterator meshesIterator = this.meshes.valueIterator();
        while (meshesIterator.hasNext()) {
            ((MeshBinding)meshesIterator.next()).close();
        }
    }

    @Override
    public void didClose() {
    }

    @Override
    public void didFail(Throwable error) {
        error.printStackTrace();
    }
}

