/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.uplink;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import swim.collections.HashTrieSet;
import swim.runtime.LinkBinding;
import swim.runtime.uplink.UplinkModem;
import swim.structure.Item;
import swim.structure.Record;
import swim.structure.Value;

public abstract class PartialUplinkModem
extends UplinkModem {
    final ConcurrentLinkedQueue<Value> downQueue = new ConcurrentLinkedQueue();
    volatile Iterator<Map.Entry<Value, Value>> syncQueue;
    volatile HashTrieSet<Value> keyQueue = HashTrieSet.empty();
    volatile Value lastKey;
    static final AtomicReferenceFieldUpdater<PartialUplinkModem, HashTrieSet<Value>> KEY_QUEUE = AtomicReferenceFieldUpdater.newUpdater(PartialUplinkModem.class, HashTrieSet.class, "keyQueue");

    public PartialUplinkModem(LinkBinding linkBinding) {
        super(linkBinding);
    }

    @Override
    protected boolean downQueueIsEmpty() {
        return this.downQueue.isEmpty() && this.syncQueue == null;
    }

    @Override
    protected void queueDown(Value body) {
        this.downQueue.add(body);
    }

    public void syncDown(Iterator<Map.Entry<Value, Value>> syncQueue) {
        this.syncQueue = syncQueue;
    }

    public void cueDownKey(Value key) {
        HashTrieSet newKeyQueue;
        HashTrieSet<Value> oldKeyQueue;
        while ((oldKeyQueue = this.keyQueue) != (newKeyQueue = oldKeyQueue.added((Object)key)) && !KEY_QUEUE.compareAndSet(this, oldKeyQueue, (HashTrieSet<Value>)newKeyQueue)) {
        }
        if (oldKeyQueue != newKeyQueue) {
            this.cueDown();
        }
    }

    public void cueDownKeys(Collection<? extends Value> keys) {
        if (!keys.isEmpty()) {
            HashTrieSet newKeyQueue;
            HashTrieSet<Value> oldKeyQueue;
            while (!KEY_QUEUE.compareAndSet(this, oldKeyQueue = this.keyQueue, (HashTrieSet<Value>)(newKeyQueue = oldKeyQueue.added(keys)))) {
            }
            this.cueDown();
        }
    }

    protected abstract Value nextDownKey(Value var1);

    @Override
    protected Value nextDownQueue() {
        Iterator<Map.Entry<Value, Value>> syncQueue = this.syncQueue;
        if (syncQueue != null) {
            if (syncQueue.hasNext()) {
                Map.Entry<Value, Value> entry = syncQueue.next();
                return Record.of().attr("update", (Value)Record.of().slot("key", entry.getKey())).concat((Item)entry.getValue());
            }
            this.syncQueue = null;
            return null;
        }
        return this.downQueue.poll();
    }

    @Override
    protected Value nextDownCue() {
        Value key;
        HashTrieSet newKeyQueue;
        HashTrieSet<Value> oldKeyQueue;
        while ((oldKeyQueue = this.keyQueue) != (newKeyQueue = oldKeyQueue.removed((Object)(key = (Value)oldKeyQueue.next((Object)this.lastKey)))) && !KEY_QUEUE.compareAndSet(this, oldKeyQueue, (HashTrieSet<Value>)newKeyQueue)) {
        }
        if (key != null) {
            this.lastKey = key;
            if (!newKeyQueue.isEmpty()) {
                int newStatus;
                int oldStatus;
                while ((oldStatus = this.status) != (newStatus = oldStatus | 0x10) && !STATUS.compareAndSet(this, oldStatus, newStatus)) {
                }
            }
            return this.nextDownKey(key);
        }
        return null;
    }
}

