/*
 * Decompiled with CFR 0.152.
 */
package swim.math;

import swim.math.BoxR2;
import swim.math.R2Form;
import swim.structure.Item;
import swim.structure.Record;
import swim.structure.Value;

final class BoxR2Form
extends R2Form<BoxR2> {
    BoxR2Form() {
    }

    public String tag() {
        return "box";
    }

    public Class<?> type() {
        return BoxR2.class;
    }

    @Override
    public double getXMin(BoxR2 box) {
        return box.xMin;
    }

    @Override
    public double getYMin(BoxR2 box) {
        return box.yMin;
    }

    @Override
    public double getXMax(BoxR2 box) {
        return box.xMax;
    }

    @Override
    public double getYMax(BoxR2 box) {
        return box.yMax;
    }

    @Override
    public boolean contains(BoxR2 outer, BoxR2 inner) {
        return outer.contains(inner);
    }

    @Override
    public boolean intersects(BoxR2 s, BoxR2 t) {
        return s.intersects(t);
    }

    public Item mold(BoxR2 box) {
        if (box != null) {
            return Record.create((int)1).attr(this.tag(), (Value)Record.create((int)4).item(box.xMin).item(box.yMin).item(box.xMax).item(box.yMax));
        }
        return Item.extant();
    }

    public BoxR2 cast(Item item) {
        Value header = item.toValue().header(this.tag());
        if (header.isDefined()) {
            double xMin = header.getItem(0).doubleValue(0.0);
            double yMin = header.getItem(1).doubleValue(0.0);
            double xMax = header.getItem(2).doubleValue(0.0);
            double yMax = header.getItem(3).doubleValue(0.0);
            return new BoxR2(xMin, yMin, xMax, yMax);
        }
        return null;
    }
}

