/*
 * Decompiled with CFR 0.152.
 */
package swim.math;

import swim.math.DimensionException;
import swim.math.TensorDims;
import swim.math.TensorForm;
import swim.math.VectorR3;
import swim.structure.Item;
import swim.structure.Record;
import swim.structure.Value;

final class VectorR3Form
extends TensorForm<VectorR3> {
    VectorR3Form() {
    }

    public String tag() {
        return "vector";
    }

    public VectorR3 unit() {
        return VectorR3.zero();
    }

    public Class<?> type() {
        return VectorR3.class;
    }

    public Item mold(VectorR3 vector) {
        if (vector != null) {
            return Record.create((int)1).attr(this.tag(), (Value)Record.create((int)3).item(vector.x).item(vector.y).item(vector.z));
        }
        return Item.extant();
    }

    public VectorR3 cast(Item item) {
        Value header = item.toValue().header(this.tag());
        if (header.isDefined()) {
            double x = header.getItem(0).doubleValue(0.0);
            double y = header.getItem(1).doubleValue(0.0);
            double z = header.getItem(2).doubleValue(0.0);
            return new VectorR3(x, y, z);
        }
        return null;
    }

    @Override
    public VectorR3 fromTensor(TensorDims dim, float[] tensor, int offset) {
        if (dim.size != 3 || dim.next != null) {
            throw new DimensionException();
        }
        double x = tensor[offset];
        double y = tensor[offset += dim.stride];
        double z = tensor[offset += dim.stride];
        return new VectorR3(x, y, z);
    }

    @Override
    public VectorR3 fromTensor(TensorDims dim, double[] tensor, int offset) {
        if (dim.size != 3 || dim.next != null) {
            throw new DimensionException();
        }
        double x = tensor[offset];
        double y = tensor[offset += dim.stride];
        double z = tensor[offset += dim.stride];
        return new VectorR3(x, y, z);
    }

    @Override
    public void toTensor(VectorR3 vector, TensorDims dim, float[] tensor, int offset) {
        if (dim.size != 3 || dim.next != null) {
            throw new DimensionException();
        }
        tensor[offset] = (float)vector.x;
        tensor[offset += dim.stride] = (float)vector.y;
        tensor[offset += dim.stride] = (float)vector.z;
    }

    @Override
    public void toTensor(VectorR3 vector, TensorDims dim, double[] tensor, int offset) {
        if (dim.size != 3 || dim.next != null) {
            throw new DimensionException();
        }
        tensor[offset] = vector.x;
        tensor[offset += dim.stride] = vector.y;
        tensor[offset += dim.stride] = vector.z;
    }

    @Override
    public Item moldTensor(TensorDims dim, float[] tensor, int offset) {
        if (dim.size != 3 || dim.next != null) {
            throw new DimensionException();
        }
        Record header = Record.create((int)3);
        header.item(tensor[offset]);
        header.item(tensor[offset += dim.stride]);
        header.item(tensor[offset += dim.stride]);
        return Record.create((int)1).attr(this.tag(), (Value)header);
    }

    @Override
    public Item moldTensor(TensorDims dim, double[] tensor, int offset) {
        if (dim.size != 3 || dim.next != null) {
            throw new DimensionException();
        }
        Record header = Record.create((int)3);
        header.item(tensor[offset]);
        header.item(tensor[offset += dim.stride]);
        header.item(tensor[offset += dim.stride]);
        return Record.create((int)1).attr(this.tag(), (Value)header);
    }

    @Override
    public void castTensor(Item item, TensorDims dim, float[] tensor, int offset) {
        if (dim.size != 3 || dim.next != null) {
            throw new DimensionException();
        }
        Value header = item.toValue().header(this.tag());
        if (header.isDefined()) {
            tensor[offset] = header.getItem(0).floatValue(0.0f);
            tensor[offset += dim.stride] = header.getItem(1).floatValue(0.0f);
            tensor[offset += dim.stride] = header.getItem(2).floatValue(0.0f);
        }
    }

    @Override
    public void castTensor(Item item, TensorDims dim, double[] tensor, int offset) {
        if (dim.size != 3 || dim.next != null) {
            throw new DimensionException();
        }
        Value header = item.toValue().header(this.tag());
        if (header.isDefined()) {
            tensor[offset] = header.getItem(0).doubleValue(0.0);
            tensor[offset += dim.stride] = header.getItem(1).doubleValue(0.0);
            tensor[offset += dim.stride] = header.getItem(2).doubleValue(0.0);
        }
    }
}

