/*
 * Decompiled with CFR 0.152.
 */
package swim.math;

import swim.math.DimensionException;
import swim.math.TensorDims;
import swim.math.TensorForm;
import swim.math.VectorZ2;
import swim.structure.Item;
import swim.structure.Record;
import swim.structure.Value;

final class VectorZ2Form
extends TensorForm<VectorZ2> {
    VectorZ2Form() {
    }

    public String tag() {
        return "vector";
    }

    public VectorZ2 unit() {
        return VectorZ2.zero();
    }

    public Class<?> type() {
        return VectorZ2.class;
    }

    public Item mold(VectorZ2 vector) {
        if (vector != null) {
            return Record.create((int)1).attr(this.tag(), (Value)Record.create((int)2).item(vector.x).item(vector.y));
        }
        return Item.extant();
    }

    public VectorZ2 cast(Item item) {
        Value header = item.toValue().header(this.tag());
        if (header.isDefined()) {
            long x = header.getItem(0).longValue(0L);
            long y = header.getItem(1).longValue(0L);
            return new VectorZ2(x, y);
        }
        return null;
    }

    @Override
    public VectorZ2 fromTensor(TensorDims dim, float[] tensor, int offset) {
        if (dim.size != 2 || dim.next != null) {
            throw new DimensionException();
        }
        long x = Math.round(tensor[offset]);
        long y = Math.round(tensor[offset += dim.stride]);
        return new VectorZ2(x, y);
    }

    @Override
    public VectorZ2 fromTensor(TensorDims dim, double[] tensor, int offset) {
        if (dim.size != 2 || dim.next != null) {
            throw new DimensionException();
        }
        long x = Math.round(tensor[offset]);
        long y = Math.round(tensor[offset += dim.stride]);
        return new VectorZ2(x, y);
    }

    @Override
    public void toTensor(VectorZ2 vector, TensorDims dim, float[] tensor, int offset) {
        if (dim.size != 2 || dim.next != null) {
            throw new DimensionException();
        }
        tensor[offset] = vector.x;
        tensor[offset += dim.stride] = vector.y;
    }

    @Override
    public void toTensor(VectorZ2 vector, TensorDims dim, double[] tensor, int offset) {
        if (dim.size != 2 || dim.next != null) {
            throw new DimensionException();
        }
        tensor[offset] = vector.x;
        tensor[offset += dim.stride] = vector.y;
    }

    public Value moldTensor(TensorDims dim, float[] tensor, int offset) {
        if (dim.size != 2 || dim.next != null) {
            throw new DimensionException();
        }
        Record header = Record.create((int)2);
        header.item(Math.round(tensor[offset]));
        header.item(Math.round(tensor[offset += dim.stride]));
        return Record.create((int)1).attr(this.tag(), (Value)header);
    }

    public Value moldTensor(TensorDims dim, double[] tensor, int offset) {
        if (dim.size != 2 || dim.next != null) {
            throw new DimensionException();
        }
        Record header = Record.create((int)2);
        header.item(Math.round(tensor[offset]));
        header.item(Math.round(tensor[offset += dim.stride]));
        return Record.create((int)1).attr(this.tag(), (Value)header);
    }

    @Override
    public void castTensor(Item item, TensorDims dim, float[] tensor, int offset) {
        if (dim.size != 2 || dim.next != null) {
            throw new DimensionException();
        }
        Value header = item.toValue().header(this.tag());
        if (header.isDefined()) {
            tensor[offset] = header.getItem(0).floatValue(0.0f);
            tensor[offset += dim.stride] = header.getItem(1).floatValue(0.0f);
        }
    }

    @Override
    public void castTensor(Item item, TensorDims dim, double[] tensor, int offset) {
        if (dim.size != 2 || dim.next != null) {
            throw new DimensionException();
        }
        Value header = item.toValue().header(this.tag());
        if (header.isDefined()) {
            tensor[offset] = header.getItem(0).doubleValue(0.0);
            tensor[offset += dim.stride] = header.getItem(1).doubleValue(0.0);
        }
    }
}

