/*
 * Decompiled with CFR 0.152.
 */
package swim.recon;

import java.nio.ByteBuffer;
import swim.codec.Base64;
import swim.codec.Output;
import swim.codec.Writer;
import swim.codec.WriterException;

final class DataWriter
extends Writer<Object, Object> {
    final ByteBuffer buffer;
    final Writer<?, ?> part;
    final int step;

    DataWriter(ByteBuffer buffer, Writer<?, ?> part, int step) {
        this.buffer = buffer;
        this.part = part;
        this.step = step;
    }

    public Writer<Object, Object> pull(Output<?> output) {
        return DataWriter.write(output, this.buffer, this.part, this.step);
    }

    static int sizeOf(int length) {
        return 1 + (length * 4 / 3 + 3 & 0xFFFFFFFC);
    }

    static Writer<Object, Object> write(Output<?> output, ByteBuffer buffer, Writer<?, ?> part, int step) {
        if (step == 1 && output.isCont()) {
            output = output.write(37);
            step = 2;
        }
        if (step == 2) {
            if ((part = part == null ? Base64.standard().writeByteBuffer(buffer, output) : part.pull(output)).isDone()) {
                part = null;
                return DataWriter.done();
            }
            if (part.isError()) {
                return part.asError();
            }
        }
        if (output.isDone()) {
            return DataWriter.error((Throwable)new WriterException("truncated"));
        }
        if (output.isError()) {
            return DataWriter.error((Throwable)output.trap());
        }
        return new DataWriter(buffer, part, step);
    }

    static Writer<Object, Object> write(Output<?> output, ByteBuffer buffer) {
        return DataWriter.write(output, buffer, null, 1);
    }
}

