/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.codec.Writer;
import swim.http.Http;
import swim.http.HttpPart;
import swim.http.HttpWriter;
import swim.util.Murmur3;

public final class ContentCoding
extends HttpPart
implements Debug {
    final String name;
    final float weight;
    private static int hashSeed;
    private static ContentCoding star;
    private static ContentCoding identity;
    private static ContentCoding compress;
    private static ContentCoding deflate;
    private static ContentCoding gzip;

    ContentCoding(String name, float weight) {
        this.name = name;
        this.weight = weight;
    }

    public String name() {
        return this.name;
    }

    public float weight() {
        return this.weight;
    }

    public ContentCoding weight(float weight) {
        if (this.weight == weight) {
            return this;
        }
        return ContentCoding.from(this.name, weight);
    }

    public boolean isStar() {
        return "*".equals(this.name);
    }

    public boolean isIdentity() {
        return "identity".equalsIgnoreCase(this.name);
    }

    public boolean isCompress() {
        return "compress".equalsIgnoreCase(this.name) || "x-compress".equalsIgnoreCase(this.name);
    }

    public boolean isDeflate() {
        return "deflate".equalsIgnoreCase(this.name);
    }

    public boolean isGzip() {
        return "gzip".equalsIgnoreCase(this.name) || "x-gzip".equalsIgnoreCase(this.name);
    }

    @Override
    public Writer<?, ?> httpWriter(HttpWriter http) {
        return http.contentCodingWriter(this.name, this.weight);
    }

    @Override
    public Writer<?, ?> writeHttp(Output<?> output, HttpWriter http) {
        return http.writeContentCoding(this.name, this.weight, output);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof ContentCoding) {
            ContentCoding that = (ContentCoding)other;
            return this.name.equals(that.name) && this.weight == that.weight;
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(ContentCoding.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.name.hashCode()), (int)Murmur3.hash((float)this.weight)));
    }

    public void debug(Output<?> output) {
        output = output.write("ContentCoding").write(46).write("from").write(40).debug((Object)this.name);
        if (this.weight != 1.0f) {
            output = output.write(", ").debug((Object)Float.valueOf(this.weight));
        }
        output = output.write(41);
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static ContentCoding star() {
        if (star == null) {
            star = new ContentCoding("*", 1.0f);
        }
        return star;
    }

    public static ContentCoding identity() {
        if (identity == null) {
            identity = new ContentCoding("identity", 1.0f);
        }
        return identity;
    }

    public static ContentCoding compress() {
        if (compress == null) {
            compress = new ContentCoding("compress", 1.0f);
        }
        return compress;
    }

    public static ContentCoding deflate() {
        if (deflate == null) {
            deflate = new ContentCoding("deflate", 1.0f);
        }
        return deflate;
    }

    public static ContentCoding gzip() {
        if (gzip == null) {
            gzip = new ContentCoding("gzip", 1.0f);
        }
        return gzip;
    }

    public static ContentCoding from(String name, float weight) {
        if (weight == 1.0f) {
            return ContentCoding.from(name);
        }
        return new ContentCoding(name, weight);
    }

    public static ContentCoding from(String name) {
        if ("*".equals(name)) {
            return ContentCoding.star();
        }
        if ("identity".equals(name)) {
            return ContentCoding.identity();
        }
        if ("compress".equals(name)) {
            return ContentCoding.compress();
        }
        if ("deflate".equals(name)) {
            return ContentCoding.deflate();
        }
        if ("gzip".equals(name)) {
            return ContentCoding.gzip();
        }
        return new ContentCoding(name, 1.0f);
    }

    public static ContentCoding parse(String string) {
        return Http.standardParser().parseContentCodingString(string);
    }
}

