/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import java.util.Iterator;
import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.codec.Writer;
import swim.collections.FingerTrieSeq;
import swim.http.Http;
import swim.http.HttpHeader;
import swim.http.HttpPart;
import swim.http.HttpWriter;
import swim.util.Murmur3;

public final class HttpChunkTrailer
extends HttpPart
implements Debug {
    final FingerTrieSeq<HttpHeader> headers;
    private static int hashSeed;
    private static HttpChunkTrailer empty;

    HttpChunkTrailer(FingerTrieSeq<HttpHeader> headers) {
        this.headers = headers;
    }

    public FingerTrieSeq<HttpHeader> headers() {
        return this.headers;
    }

    @Override
    public Writer<?, ?> httpWriter(HttpWriter http) {
        return http.chunkTrailerWriter(this.headers.iterator());
    }

    @Override
    public Writer<?, ?> writeHttp(Output<?> output, HttpWriter http) {
        return http.writeChunkTrailer(this.headers.iterator(), output);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof HttpChunkTrailer) {
            HttpChunkTrailer that = (HttpChunkTrailer)other;
            return this.headers.equals(that.headers);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(HttpChunkTrailer.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)hashSeed, (int)this.headers.hashCode()));
    }

    public void debug(Output<?> output) {
        output = output.write("HttpChunkTrailer").write(46);
        Iterator headers = this.headers.iterator();
        if (headers.hasNext()) {
            output = output.write("apply").write(40).debug(headers.next());
            while (headers.hasNext()) {
                output = output.write(", ").debug(headers.next());
            }
            output = output.write(41);
        } else {
            output = output.write("empty").write(40).write(41);
        }
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static HttpChunkTrailer empty() {
        if (empty == null) {
            empty = new HttpChunkTrailer((FingerTrieSeq<HttpHeader>)FingerTrieSeq.empty());
        }
        return empty;
    }

    public static HttpChunkTrailer from(FingerTrieSeq<HttpHeader> headers) {
        if (headers.isEmpty()) {
            return HttpChunkTrailer.empty();
        }
        return new HttpChunkTrailer(headers);
    }

    public static HttpChunkTrailer from(HttpHeader ... headers) {
        if (headers.length == 0) {
            return HttpChunkTrailer.empty();
        }
        return new HttpChunkTrailer((FingerTrieSeq<HttpHeader>)FingerTrieSeq.of((Object[])headers));
    }

    public static HttpChunkTrailer parse(String chunkTrailer) {
        return Http.standardParser().parseChunkTrailerString(chunkTrailer);
    }
}

