/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Parser;
import swim.http.Http;
import swim.http.HttpMethod;
import swim.http.HttpParser;

final class HttpMethodParser
extends Parser<HttpMethod> {
    final HttpParser http;
    final StringBuilder name;
    final int step;

    HttpMethodParser(HttpParser http, StringBuilder name, int step) {
        this.http = http;
        this.name = name;
        this.step = step;
    }

    HttpMethodParser(HttpParser http) {
        this(http, null, 1);
    }

    public Parser<HttpMethod> feed(Input input) {
        return HttpMethodParser.parse(input, this.http, this.name, this.step);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Parser<HttpMethod> parse(Input input, HttpParser http, StringBuilder name, int step) {
        int c = 0;
        if (step == 1) {
            if (input.isCont()) {
                c = input.head();
                if (!Http.isTokenChar(c)) return HttpMethodParser.error((Diagnostic)Diagnostic.expected((String)"HTTP method", (Input)input));
                input = input.step();
                name = new StringBuilder();
                name.appendCodePoint(c);
                step = 2;
            } else if (input.isDone()) {
                return HttpMethodParser.error((Diagnostic)Diagnostic.expected((String)"HTTP method", (Input)input));
            }
        }
        if (step == 2) {
            while (input.isCont() && Http.isTokenChar(c = input.head())) {
                input = input.step();
                name.appendCodePoint(c);
            }
            if (!input.isEmpty()) {
                return HttpMethodParser.done((Object)http.method(name.toString()));
            }
        }
        if (!input.isError()) return new HttpMethodParser(http, name, step);
        return HttpMethodParser.error((Throwable)input.trap());
    }

    static Parser<HttpMethod> parse(Input input, HttpParser http) {
        return HttpMethodParser.parse(input, http, null, 1);
    }
}

