/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import java.util.Map;
import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.codec.Writer;
import swim.collections.HashTrieMap;
import swim.http.Http;
import swim.http.HttpPart;
import swim.http.HttpWriter;
import swim.util.Murmur3;

public final class TransferCoding
extends HttpPart
implements Debug {
    final String name;
    final HashTrieMap<String, String> params;
    private static int hashSeed;
    private static TransferCoding chunked;
    private static TransferCoding compress;
    private static TransferCoding deflate;
    private static TransferCoding gzip;

    TransferCoding(String name, HashTrieMap<String, String> params) {
        this.name = name;
        this.params = params;
    }

    TransferCoding(String name) {
        this(name, (HashTrieMap<String, String>)HashTrieMap.empty());
    }

    public String name() {
        return this.name;
    }

    public HashTrieMap<String, String> params() {
        return this.params;
    }

    public String getParam(String key) {
        return (String)this.params.get((Object)key);
    }

    public TransferCoding param(String key, String value) {
        return TransferCoding.from(this.name, (HashTrieMap<String, String>)this.params.updated((Object)key, (Object)value));
    }

    public boolean isChunked() {
        return "chunked".equals(this.name);
    }

    public boolean isCompress() {
        return "compress".equals(this.name);
    }

    public boolean isDeflate() {
        return "deflate".equals(this.name);
    }

    public boolean isGzip() {
        return "gzip".equals(this.name);
    }

    @Override
    public Writer<?, ?> httpWriter(HttpWriter http) {
        return http.transferCodingWriter(this.name, this.params);
    }

    @Override
    public Writer<?, ?> writeHttp(Output<?> output, HttpWriter http) {
        return http.writeTransferCoding(this.name, this.params, output);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof TransferCoding) {
            TransferCoding that = (TransferCoding)other;
            return this.name.equals(that.name) && this.params.equals(that.params);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(TransferCoding.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.name.hashCode()), (int)this.params.hashCode()));
    }

    public void debug(Output<?> output) {
        output = output.write("TransferCoding").write(46).write("from").write(40).debug((Object)this.name).write(41);
        for (Map.Entry param : this.params) {
            output = output.write(46).write("param").write(40).debug(param.getKey()).write(", ").debug(param.getValue()).write(41);
        }
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static TransferCoding chunked() {
        if (chunked == null) {
            chunked = new TransferCoding("chunked");
        }
        return chunked;
    }

    public static TransferCoding compress() {
        if (compress == null) {
            compress = new TransferCoding("compress");
        }
        return compress;
    }

    public static TransferCoding deflate() {
        if (deflate == null) {
            deflate = new TransferCoding("deflate");
        }
        return deflate;
    }

    public static TransferCoding gzip() {
        if (gzip == null) {
            gzip = new TransferCoding("gzip");
        }
        return gzip;
    }

    public static TransferCoding from(String name, HashTrieMap<String, String> params) {
        if (params.isEmpty()) {
            if ("chunked".equals(name)) {
                return TransferCoding.chunked();
            }
            if ("compress".equals(name)) {
                return TransferCoding.compress();
            }
            if ("deflate".equals(name)) {
                return TransferCoding.deflate();
            }
            if ("gzip".equals(name)) {
                return TransferCoding.gzip();
            }
        }
        return new TransferCoding(name, params);
    }

    public static TransferCoding from(String name) {
        return TransferCoding.from(name, (HashTrieMap<String, String>)HashTrieMap.empty());
    }

    public static TransferCoding parse(String string) {
        return Http.standardParser().parseTransferCodingString(string);
    }
}

