/*
 * Decompiled with CFR 0.152.
 */
package swim.http.header;

import java.util.Arrays;
import swim.codec.Base64;
import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Output;
import swim.codec.Parser;
import swim.codec.Unicode;
import swim.codec.Writer;
import swim.http.HttpHeader;
import swim.http.HttpParser;
import swim.http.HttpWriter;
import swim.http.header.SecWebSocketAcceptParser;
import swim.util.Murmur3;

public final class SecWebSocketAccept
extends HttpHeader {
    final byte[] digest;
    private static int hashSeed;

    SecWebSocketAccept(byte[] digest) {
        this.digest = digest;
    }

    @Override
    public String lowerCaseName() {
        return "sec-websocket-accept";
    }

    @Override
    public String name() {
        return "Sec-WebSocket-Accept";
    }

    public byte[] digest() {
        return this.digest;
    }

    @Override
    public Writer<?, ?> writeHttpValue(Output<?> output, HttpWriter http) {
        return Base64.standard().writeByteArray(this.digest, output);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof SecWebSocketAccept) {
            SecWebSocketAccept that = (SecWebSocketAccept)other;
            return Arrays.equals(this.digest, that.digest);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(SecWebSocketAccept.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)hashSeed, (int)Arrays.hashCode(this.digest)));
    }

    public void debug(Output<?> output) {
        output = output.write("SecWebSocketAccept").write(46).write("from").write(40).write(34);
        Base64.standard().writeByteArray(this.digest, output);
        output = output.write(34).write(41);
    }

    public static SecWebSocketAccept from(byte[] digest) {
        return new SecWebSocketAccept(digest);
    }

    public static SecWebSocketAccept from(String digestString) {
        Input input = Unicode.stringInput((String)digestString);
        Parser parser = Base64.standard().parseByteArray(input);
        if (input.isCont() && !parser.isError()) {
            parser = Parser.error((Diagnostic)Diagnostic.unexpected((Input)input));
        }
        return new SecWebSocketAccept((byte[])parser.bind());
    }

    public static Parser<SecWebSocketAccept> parseHttpValue(Input input, HttpParser http) {
        return SecWebSocketAcceptParser.parse(input);
    }
}

