/*
 * Decompiled with CFR 0.152.
 */
package swim.http.header;

import java.util.Iterator;
import swim.codec.Output;
import swim.codec.Writer;
import swim.codec.WriterException;
import swim.http.HttpWriter;
import swim.http.Product;

final class ServerWriter
extends Writer<Object, Object> {
    final HttpWriter http;
    final Iterator<Product> products;
    final Writer<?, ?> part;
    final int step;

    ServerWriter(HttpWriter http, Iterator<Product> products, Writer<?, ?> part, int step) {
        this.http = http;
        this.products = products;
        this.part = part;
        this.step = step;
    }

    public Writer<Object, Object> pull(Output<?> output) {
        return ServerWriter.write(output, this.http, this.products, this.part, this.step);
    }

    static Writer<Object, Object> write(Output<?> output, HttpWriter http, Iterator<Product> products, Writer<?, ?> part, int step) {
        while (true) {
            if (step == 1) {
                if (part == null) {
                    if (!products.hasNext()) {
                        return ServerWriter.done();
                    }
                    part = products.next().writeHttp(output, http);
                } else {
                    part = part.pull(output);
                }
                if (part.isDone()) {
                    part = null;
                    if (!products.hasNext()) {
                        return ServerWriter.done();
                    }
                    step = 2;
                } else if (part.isError()) {
                    return part.asError();
                }
            }
            if (step != 2 || !output.isCont()) break;
            output = output.write(32);
            step = 1;
        }
        if (output.isDone()) {
            return ServerWriter.error((Throwable)new WriterException("truncated"));
        }
        if (output.isError()) {
            return ServerWriter.error((Throwable)output.trap());
        }
        return new ServerWriter(http, products, part, step);
    }

    static Writer<Object, Object> write(Output<?> output, HttpWriter http, Iterator<Product> products) {
        return ServerWriter.write(output, http, products, null, 1);
    }
}

