/*
 * Decompiled with CFR 0.152.
 */
package swim.cli;

import swim.api.downlink.Downlink;
import swim.api.downlink.EventDownlink;
import swim.api.ref.SwimRef;
import swim.args.Arg;
import swim.args.Cmd;
import swim.args.Opt;
import swim.cli.DownlinkGetter;
import swim.cli.DownlinkLogger;
import swim.uri.Uri;

public class CliClient {
    protected final SwimRef swim;

    public CliClient(SwimRef swim) {
        this.swim = swim;
    }

    public final SwimRef swim() {
        return this.swim;
    }

    public String name() {
        return "swim-cli";
    }

    public Cmd mainCmd() {
        return Cmd.of((String)this.name()).cmd(this.linkCmd()).cmd(this.syncCmd()).cmd(this.getCmd()).cmd(this.reflectCmd()).helpCmd();
    }

    public Cmd linkCmd() {
        return Cmd.of((String)"link").desc("stream changes to a lane of a remote node").opt(Opt.of((String)"host").flag('h').arg("hostUri").desc("remote host to link")).opt(Opt.of((String)"node").flag('n').arg("nodeUri").desc("remote node to link")).opt(Opt.of((String)"lane").flag('l').arg("laneUri").desc("lane to link")).opt(Opt.of((String)"format").flag('f').arg("json|recon").desc("event output format")).helpCmd().exec(this::runLinkCmd);
    }

    public Cmd syncCmd() {
        return Cmd.of((String)"sync").desc("stream the current state and changes to a lane of a remote node").opt(Opt.of((String)"host").flag('h').arg("hostUri").desc("remote host to link")).opt(Opt.of((String)"node").flag('n').arg("nodeUri").desc("remote node to link")).opt(Opt.of((String)"lane").flag('l').arg("laneUri").desc("lane to link")).opt(Opt.of((String)"format").flag('f').arg("json|recon").desc("event output format")).helpCmd().exec(this::runSyncCmd);
    }

    public Cmd getCmd() {
        return Cmd.of((String)"get").desc("fetch the current state of a lane of a remote node").opt(Opt.of((String)"host").flag('h').arg("hostUri").desc("remote host to link")).opt(Opt.of((String)"node").flag('n').arg("nodeUri").desc("remote node to link")).opt(Opt.of((String)"lane").flag('l').arg("laneUri").desc("lane to link")).opt(Opt.of((String)"format").flag('f').arg("json|recon").desc("event output format")).helpCmd().exec(this::runGetCmd);
    }

    public Cmd reflectCmd() {
        return Cmd.of((String)"reflect").desc("stream introspection metadata").opt(Opt.of((String)"root").flag('r').arg("rootUri").desc("endpoint to introspect")).opt(Opt.of((String)"mesh").flag('m').arg(Arg.of((String)"meshUri").optional(true)).desc("introspect default or specified mesh")).opt(Opt.of((String)"part").flag('p').arg(Arg.of((String)"partKey").optional(true)).desc("introspect default or specified partition")).opt(Opt.of((String)"host").flag('h').arg(Arg.of((String)"hostUri").optional(true)).desc("introspect default or specified host")).opt(Opt.of((String)"node").flag('n').arg("nodeUri").desc("introspect specified node")).opt(Opt.of((String)"lane").flag('l').arg("laneUri").desc("introspect specified lane")).opt(Opt.of((String)"link").flag('l').desc("introspect link behavior")).opt(Opt.of((String)"router").flag('r').desc("introspect router behavior")).opt(Opt.of((String)"data").desc("introspect data behavior")).opt(Opt.of((String)"system").desc("introspect system behavior")).opt(Opt.of((String)"process").desc("introspect process behavior")).opt(Opt.of((String)"stats").flag('s').desc("stream introspection statistics")).opt(Opt.of((String)"format").flag('f').arg("json|recon").desc("event output format")).cmd(this.reflectLogCmd()).helpCmd().exec(this::runReflectCmd);
    }

    public Cmd reflectLogCmd() {
        return Cmd.of((String)"log").desc("stream log events").opt(Opt.of((String)"trace").flag('t').desc("stream trace log messages")).opt(Opt.of((String)"debug").flag('d').desc("stream debug log messages")).opt(Opt.of((String)"info").flag('i').desc("stream info log messages")).opt(Opt.of((String)"warn").flag('w').desc("stream warning log messages")).opt(Opt.of((String)"error").flag('e').desc("stream error log messages")).helpCmd().exec(this::runReflectLogCmd);
    }

    public void runLinkCmd(Cmd cmd) {
        Downlink downlink = this.downlink(cmd).keepSynced(false);
        DownlinkLogger downlinkLogger = this.downlinkLogger(downlink, cmd);
        downlinkLogger.open();
    }

    public void runSyncCmd(Cmd cmd) {
        Downlink downlink = this.downlink(cmd).keepSynced(true);
        DownlinkLogger downlinkLogger = this.downlinkLogger(downlink, cmd);
        downlinkLogger.open();
    }

    public void runGetCmd(Cmd cmd) {
        Downlink downlink = this.downlink(cmd).keepSynced(true);
        DownlinkGetter downlinkGetter = this.downlinkGetter(downlink, cmd);
        downlinkGetter.open();
    }

    public void runReflectCmd(Cmd cmd) {
        String rootUri = cmd.getOpt("root").getValue();
        if (rootUri != null) {
            String meshUri = cmd.getOpt("mesh").getValue();
            String hostUri = cmd.getOpt("host").getValue();
            String nodeUri = cmd.getOpt("node").getValue();
            String laneUri = cmd.getOpt("lane").getValue();
            if (nodeUri != null) {
                Uri metaNodeUri = meshUri != null ? Uri.parse((String)"swim:meta:mesh").appendedPath(new String[]{meshUri, "node", nodeUri}) : (hostUri != null ? Uri.parse((String)"swim:meta:host").appendedPath(new String[]{hostUri, "node", nodeUri}) : Uri.parse((String)"swim:meta:node").appendedPath(nodeUri));
                if (laneUri != null) {
                    metaNodeUri = metaNodeUri.appendedPath(new String[]{"lane", laneUri});
                    EventDownlink downlink = this.swim.downlink().hostUri(rootUri).nodeUri(metaNodeUri).laneUri("linkStats").keepSynced(true);
                    DownlinkLogger downlinkLogger = this.downlinkLogger((Downlink)downlink, cmd);
                    downlinkLogger.open();
                } else if (cmd.getOpt("link").isDefined()) {
                    EventDownlink downlink = this.swim.downlink().hostUri(rootUri).nodeUri(metaNodeUri).laneUri("linkStats").keepSynced(true);
                    DownlinkLogger downlinkLogger = this.downlinkLogger((Downlink)downlink, cmd);
                    downlinkLogger.open();
                } else {
                    EventDownlink downlink = this.swim.downlink().hostUri(rootUri).nodeUri(metaNodeUri).laneUri("routerStats").keepSynced(true);
                    DownlinkLogger downlinkLogger = this.downlinkLogger((Downlink)downlink, cmd);
                    downlinkLogger.open();
                }
            } else if (hostUri != null) {
                Uri metaNodeUri;
                if (meshUri != null) {
                    metaNodeUri = Uri.parse((String)"swim:meta:mesh").appendedPath(meshUri);
                    if (hostUri != null) {
                        metaNodeUri = metaNodeUri.appendedPath(new String[]{"host", hostUri});
                    }
                } else {
                    metaNodeUri = Uri.parse((String)"swim:meta:host");
                    if (hostUri != null) {
                        metaNodeUri = metaNodeUri.appendedPath(hostUri);
                    }
                }
                if (cmd.getOpt("process").isDefined()) {
                    EventDownlink downlink = this.swim.downlink().hostUri(rootUri).nodeUri(metaNodeUri).laneUri("processStats").keepSynced(true);
                    DownlinkLogger downlinkLogger = this.downlinkLogger((Downlink)downlink, cmd);
                    downlinkLogger.open();
                } else if (cmd.getOpt("system").isDefined()) {
                    EventDownlink downlink = this.swim.downlink().hostUri(rootUri).nodeUri(metaNodeUri).laneUri("systemStats").keepSynced(true);
                    DownlinkLogger downlinkLogger = this.downlinkLogger((Downlink)downlink, cmd);
                    downlinkLogger.open();
                } else if (cmd.getOpt("data").isDefined()) {
                    EventDownlink downlink = this.swim.downlink().hostUri(rootUri).nodeUri(metaNodeUri).laneUri("dataStats").keepSynced(true);
                    DownlinkLogger downlinkLogger = this.downlinkLogger((Downlink)downlink, cmd);
                    downlinkLogger.open();
                } else if (cmd.getOpt("router").isDefined()) {
                    EventDownlink downlink = this.swim.downlink().hostUri(rootUri).nodeUri(metaNodeUri).laneUri("routerStats").keepSynced(true);
                    DownlinkLogger downlinkLogger = this.downlinkLogger((Downlink)downlink, cmd);
                    downlinkLogger.open();
                } else if (cmd.getOpt("link").isDefined()) {
                    EventDownlink downlink = this.swim.downlink().hostUri(rootUri).nodeUri(metaNodeUri).laneUri("linkStats").keepSynced(true);
                    DownlinkLogger downlinkLogger = this.downlinkLogger((Downlink)downlink, cmd);
                    downlinkLogger.open();
                } else {
                    EventDownlink downlink = this.swim.downlink().hostUri(rootUri).nodeUri(metaNodeUri).laneUri("hostStats").keepSynced(true);
                    DownlinkLogger downlinkLogger = this.downlinkLogger((Downlink)downlink, cmd);
                    downlinkLogger.open();
                }
            } else if (meshUri != null) {
                Uri metaNodeUri = Uri.parse((String)"swim:meta:mesh");
                if (meshUri != null) {
                    metaNodeUri = metaNodeUri.appendedPath(meshUri);
                }
                if (cmd.getOpt("process").isDefined()) {
                    EventDownlink downlink = this.swim.downlink().hostUri(rootUri).nodeUri(metaNodeUri).laneUri("processStats").keepSynced(true);
                    DownlinkLogger downlinkLogger = this.downlinkLogger((Downlink)downlink, cmd);
                    downlinkLogger.open();
                } else if (cmd.getOpt("system").isDefined()) {
                    EventDownlink downlink = this.swim.downlink().hostUri(rootUri).nodeUri(metaNodeUri).laneUri("systemStats").keepSynced(true);
                    DownlinkLogger downlinkLogger = this.downlinkLogger((Downlink)downlink, cmd);
                    downlinkLogger.open();
                } else if (cmd.getOpt("data").isDefined()) {
                    EventDownlink downlink = this.swim.downlink().hostUri(rootUri).nodeUri(metaNodeUri).laneUri("dataStats").keepSynced(true);
                    DownlinkLogger downlinkLogger = this.downlinkLogger((Downlink)downlink, cmd);
                    downlinkLogger.open();
                } else if (cmd.getOpt("router").isDefined()) {
                    EventDownlink downlink = this.swim.downlink().hostUri(rootUri).nodeUri(metaNodeUri).laneUri("routerStats").keepSynced(true);
                    DownlinkLogger downlinkLogger = this.downlinkLogger((Downlink)downlink, cmd);
                    downlinkLogger.open();
                } else if (cmd.getOpt("link").isDefined()) {
                    EventDownlink downlink = this.swim.downlink().hostUri(rootUri).nodeUri(metaNodeUri).laneUri("linkStats").keepSynced(true);
                    DownlinkLogger downlinkLogger = this.downlinkLogger((Downlink)downlink, cmd);
                    downlinkLogger.open();
                } else {
                    EventDownlink downlink = this.swim.downlink().hostUri(rootUri).nodeUri(metaNodeUri).laneUri("meshStats").keepSynced(true);
                    DownlinkLogger downlinkLogger = this.downlinkLogger((Downlink)downlink, cmd);
                    downlinkLogger.open();
                }
            } else if (cmd.getOpt("process").isDefined()) {
                EventDownlink downlink = this.swim.downlink().hostUri(rootUri).nodeUri("swim:meta:root").laneUri("processStats").keepSynced(true);
                DownlinkLogger downlinkLogger = this.downlinkLogger((Downlink)downlink, cmd);
                downlinkLogger.open();
            } else if (cmd.getOpt("system").isDefined()) {
                EventDownlink downlink = this.swim.downlink().hostUri(rootUri).nodeUri("swim:meta:root").laneUri("systemStats").keepSynced(true);
                DownlinkLogger downlinkLogger = this.downlinkLogger((Downlink)downlink, cmd);
                downlinkLogger.open();
            } else if (cmd.getOpt("data").isDefined()) {
                EventDownlink downlink = this.swim.downlink().hostUri(rootUri).nodeUri("swim:meta:root").laneUri("dataStats").keepSynced(true);
                DownlinkLogger downlinkLogger = this.downlinkLogger((Downlink)downlink, cmd);
                downlinkLogger.open();
            } else if (cmd.getOpt("link").isDefined()) {
                EventDownlink downlink = this.swim.downlink().hostUri(rootUri).nodeUri("swim:meta:root").laneUri("linkStats").keepSynced(true);
                DownlinkLogger downlinkLogger = this.downlinkLogger((Downlink)downlink, cmd);
                downlinkLogger.open();
            } else {
                EventDownlink downlink = this.swim.downlink().hostUri(rootUri).nodeUri("swim:meta:root").laneUri("routerStats").keepSynced(true);
                DownlinkLogger downlinkLogger = this.downlinkLogger((Downlink)downlink, cmd);
                downlinkLogger.open();
            }
        }
    }

    public void runReflectLogCmd(Cmd cmd) {
    }

    protected Downlink downlink(Cmd cmd) {
        return this.swim.downlink().hostUri(cmd.getOpt("host").getValue()).nodeUri(cmd.getOpt("node").getValue()).laneUri(cmd.getOpt("lane").getValue());
    }

    protected DownlinkLogger downlinkLogger(Downlink downlink, Cmd cmd) {
        String format = cmd.getOpt("format").getValue();
        return new DownlinkLogger(downlink, format);
    }

    protected DownlinkGetter downlinkGetter(Downlink downlink, Cmd cmd) {
        String format = cmd.getOpt("format").getValue();
        return new DownlinkGetter(downlink, format);
    }
}

