/*
 * Decompiled with CFR 0.152.
 */
package swim.xml;

import swim.codec.Output;
import swim.codec.Unicode;
import swim.structure.Attr;
import swim.structure.Item;
import swim.structure.Record;
import swim.structure.Slot;
import swim.structure.Text;
import swim.structure.Value;
import swim.util.Builder;
import swim.xml.XmlParser;

public class XmlModelParser
extends XmlParser<Item, Value> {
    static final Text XML_TAG = Text.from((String)"xml");
    static final Text XML_DOCTYPE_TAG = Text.from((String)"xml:doctype");
    static final Text XML_COMMENT_TAG = Text.from((String)"xml:comment");
    static final Text XML_PI_TAG = Text.from((String)"xml:pi");

    @Override
    public Item item(Value value) {
        return value;
    }

    @Override
    public String name(String name) {
        return name;
    }

    @Override
    public Item attribute(String name, Value value) {
        return Slot.of((String)name, (Value)value);
    }

    @Override
    public Value attributes() {
        return Value.extant();
    }

    @Override
    public Item xml(Value attributes) {
        return Attr.of((Text)XML_TAG, (Value)attributes);
    }

    @Override
    public Item doctype(String name) {
        return Attr.of((Text)XML_DOCTYPE_TAG, (String)name);
    }

    @Override
    public Item doctype(String name, String systemId) {
        return Attr.of((Text)XML_DOCTYPE_TAG, (Value)Record.of((Object[])new Object[]{Slot.of((String)"name", (String)name), Slot.of((String)"system", (String)systemId)}));
    }

    @Override
    public Item doctype(String name, String publicId, String systemId) {
        return Attr.of((Text)XML_DOCTYPE_TAG, (Value)Record.of((Object[])new Object[]{Slot.of((String)"name", (String)name), Slot.of((String)"public", (String)publicId), Slot.of((String)"system", (String)systemId)}));
    }

    @Override
    public Item tag(String name) {
        return Attr.of((String)name);
    }

    @Override
    public Item tag(String name, Value attributes) {
        return Attr.of((String)name, (Value)attributes);
    }

    @Override
    public Item comment(String value) {
        return Attr.of((Text)XML_COMMENT_TAG, (String)value);
    }

    @Override
    public Item pi(String target, String value) {
        return Attr.of((Text)XML_PI_TAG, (Value)Record.of((Object[])new Object[]{target, value}));
    }

    @Override
    public Output<String> nameOutput() {
        return Unicode.stringOutput();
    }

    @Override
    public Output<Value> textOutput() {
        return Text.output();
    }

    @Override
    public Builder<Item, Value> attributesBuilder() {
        return Record.create();
    }

    @Override
    public Builder<Item, Value> tagBuilder(String name) {
        Record builder = Record.create();
        builder.add((Object)this.tag(name));
        return builder;
    }

    @Override
    public Builder<Item, Value> tagBuilder(String name, Value attributes) {
        Record builder = Record.create();
        builder.add((Object)this.tag(name, attributes));
        return builder;
    }

    @Override
    public Builder<Item, Value> documentBuilder() {
        return Record.create();
    }

    @Override
    public Builder<Item, Value> fragmentBuilder() {
        return Record.create();
    }
}

