/*
 * Decompiled with CFR 0.152.
 */
package swim.io.http;

import java.net.InetSocketAddress;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import swim.codec.Decoder;
import swim.codec.Parser;
import swim.codec.Utf8;
import swim.collections.FingerTrieSeq;
import swim.http.Http;
import swim.http.HttpRequest;
import swim.http.HttpResponse;
import swim.io.FlowControl;
import swim.io.FlowModifier;
import swim.io.Modem;
import swim.io.ModemContext;
import swim.io.Socket;
import swim.io.http.HttpClient;
import swim.io.http.HttpClientContext;
import swim.io.http.HttpClientRequester;
import swim.io.http.HttpRequester;
import swim.io.http.HttpSettings;

public class HttpClientModem
implements Modem<HttpResponse<?>, HttpRequest<?>>,
HttpClientContext {
    protected final HttpClient client;
    protected final HttpSettings httpSettings;
    volatile FingerTrieSeq<HttpClientRequester<?>> requesters;
    volatile FingerTrieSeq<HttpClientRequester<?>> responders;
    volatile HttpClientRequester<?> responding;
    protected ModemContext<HttpResponse<?>, HttpRequest<?>> context;
    static final AtomicReferenceFieldUpdater<HttpClientModem, FingerTrieSeq<HttpClientRequester<?>>> REQUESTERS = AtomicReferenceFieldUpdater.newUpdater(HttpClientModem.class, FingerTrieSeq.class, "requesters");
    static final AtomicReferenceFieldUpdater<HttpClientModem, FingerTrieSeq<HttpClientRequester<?>>> RESPONDERS = AtomicReferenceFieldUpdater.newUpdater(HttpClientModem.class, FingerTrieSeq.class, "responders");
    static final AtomicReferenceFieldUpdater<HttpClientModem, HttpClientRequester<?>> RESPONDING = AtomicReferenceFieldUpdater.newUpdater(HttpClientModem.class, HttpClientRequester.class, "responding");

    public HttpClientModem(HttpClient client, HttpSettings httpSettings) {
        this.client = client;
        this.httpSettings = httpSettings;
        this.requesters = FingerTrieSeq.empty();
        this.responders = FingerTrieSeq.empty();
    }

    public ModemContext<HttpResponse<?>, HttpRequest<?>> modemContext() {
        return this.context;
    }

    public void setModemContext(ModemContext<HttpResponse<?>, HttpRequest<?>> context) {
        this.context = context;
        this.client.setHttpClientContext(this);
    }

    public long idleTimeout() {
        return this.client.idleTimeout();
    }

    public void doRead() {
    }

    public void didRead(HttpResponse<?> response) {
        if (RESPONDING.get(this) == null) {
            this.willRespond(response);
        } else {
            this.didRespond(response);
        }
    }

    public void doWrite() {
    }

    public void didWrite(HttpRequest<?> request) {
        this.didRequest(request);
    }

    public void willConnect() {
        this.client.willConnect();
    }

    public void didConnect() {
        this.client.didConnect();
    }

    public void willSecure() {
        this.client.willSecure();
    }

    public void didSecure() {
        this.client.didSecure();
    }

    public void willBecome(Socket socket) {
        this.client.willBecome(socket);
    }

    public void didBecome(Socket socket) {
        this.client.didBecome(socket);
    }

    public void didTimeout() {
        for (HttpClientRequester responderContext : RESPONDERS.get(this)) {
            responderContext.didTimeout();
        }
        this.client.didTimeout();
    }

    public void didDisconnect() {
        FingerTrieSeq newResponders;
        FingerTrieSeq<HttpClientRequester<?>> oldResponders;
        REQUESTERS.set(this, FingerTrieSeq.empty());
        while ((oldResponders = RESPONDERS.get(this)) != (newResponders = FingerTrieSeq.empty())) {
            if (!RESPONDERS.compareAndSet(this, oldResponders, newResponders)) continue;
            for (HttpClientRequester responderContext : oldResponders) {
                responderContext.didDisconnect();
            }
        }
        this.client.didDisconnect();
        this.close();
    }

    public void didFail(Throwable error) {
        FingerTrieSeq newResponders;
        FingerTrieSeq<HttpClientRequester<?>> oldResponders;
        REQUESTERS.set(this, FingerTrieSeq.empty());
        while ((oldResponders = RESPONDERS.get(this)) != (newResponders = FingerTrieSeq.empty())) {
            if (!RESPONDERS.compareAndSet(this, oldResponders, newResponders)) continue;
            for (HttpClientRequester responderContext : oldResponders) {
                responderContext.didFail(error);
            }
        }
        this.client.didFail(error);
        this.close();
    }

    public boolean isConnected() {
        ModemContext<HttpResponse<?>, HttpRequest<?>> context = this.context;
        return context != null && context.isConnected();
    }

    public boolean isClient() {
        return true;
    }

    public boolean isServer() {
        return false;
    }

    public boolean isSecure() {
        ModemContext<HttpResponse<?>, HttpRequest<?>> context = this.context;
        return context != null && context.isSecure();
    }

    public String securityProtocol() {
        return this.context.securityProtocol();
    }

    public String cipherSuite() {
        return this.context.cipherSuite();
    }

    public InetSocketAddress localAddress() {
        return this.context.localAddress();
    }

    public Principal localPrincipal() {
        return this.context.localPrincipal();
    }

    public Collection<Certificate> localCertificates() {
        return this.context.localCertificates();
    }

    public InetSocketAddress remoteAddress() {
        return this.context.remoteAddress();
    }

    public Principal remotePrincipal() {
        return this.context.remotePrincipal();
    }

    public Collection<Certificate> remoteCertificates() {
        return this.context.remoteCertificates();
    }

    public FlowControl flowControl() {
        return this.context.flowControl();
    }

    public void flowControl(FlowControl flowControl) {
        this.context.flowControl(flowControl);
    }

    public FlowControl flowControl(FlowModifier flowModifier) {
        return this.context.flowControl(flowModifier);
    }

    @Override
    public HttpSettings httpSettings() {
        return this.httpSettings;
    }

    @Override
    public void doRequest(HttpRequester<?> requester) {
        block2: {
            FingerTrieSeq newResponders;
            FingerTrieSeq<HttpClientRequester<?>> oldResponders;
            FingerTrieSeq newRequesters;
            FingerTrieSeq<HttpClientRequester<?>> oldRequesters;
            HttpClientRequester requesterContext = new HttpClientRequester(this, requester);
            requester.setHttpRequesterContext(requesterContext);
            while (!REQUESTERS.compareAndSet(this, oldRequesters = REQUESTERS.get(this), newRequesters = oldRequesters.appended(requesterContext))) {
            }
            while (!RESPONDERS.compareAndSet(this, oldResponders = RESPONDERS.get(this), newResponders = oldResponders.appended(requesterContext))) {
            }
            if (!oldRequesters.isEmpty()) break block2;
            requesterContext.doRequest();
        }
    }

    @Override
    public void readResponse() {
        this.doReadResponseMessage();
    }

    @Override
    public void become(Socket socket) {
        this.context.become(socket);
    }

    @Override
    public void close() {
        this.context.close();
    }

    void doWriteRequest(HttpRequest<?> request) {
        this.willRequest(request);
        this.context.write(request.httpEncoder());
    }

    void willRequest(HttpRequest<?> request) {
        this.client.willRequest(request);
        ((HttpClientRequester)RESPONDERS.get(this).head()).willRequest(request);
    }

    void didRequest(HttpRequest<?> request) {
        block1: {
            FingerTrieSeq newRequesters;
            FingerTrieSeq<HttpClientRequester<?>> oldRequesters;
            while (!REQUESTERS.compareAndSet(this, oldRequesters = REQUESTERS.get(this), newRequesters = oldRequesters.tail())) {
            }
            HttpClientRequester requesterContext = (HttpClientRequester)oldRequesters.head();
            requesterContext.didRequest(request);
            this.client.didRequest(request);
            if (newRequesters.isEmpty()) break block1;
            ((HttpClientRequester)newRequesters.head()).doRequest();
        }
    }

    void doReadResponseMessage() {
        this.context.read((Decoder)Utf8.decodedParser((Parser)Http.standardParser().responseParser()));
    }

    void doReadResponseEntity(Decoder<HttpResponse<?>> entityDecoder) {
        if (entityDecoder.isCont()) {
            this.context.read(entityDecoder);
        } else {
            this.didRead((HttpResponse)entityDecoder.bind());
        }
    }

    void willRespond(HttpResponse<?> response) {
        FingerTrieSeq newResponders;
        FingerTrieSeq<HttpClientRequester<?>> oldResponders;
        while (!RESPONDERS.compareAndSet(this, oldResponders = RESPONDERS.get(this), newResponders = oldResponders.tail())) {
        }
        HttpClientRequester requesterContext = (HttpClientRequester)oldResponders.head();
        if (!RESPONDING.compareAndSet(this, null, requesterContext)) {
            throw new AssertionError();
        }
        requesterContext.willRespond(response);
        this.client.willRespond(response);
    }

    void didRespond(HttpResponse<?> response) {
        HttpClientRequester requesterContext = RESPONDING.getAndSet(this, null);
        requesterContext.didRespond(response);
        this.client.didRespond(response);
    }
}

